/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.gridselect;

import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

public abstract class AbstractGridSelect<V, F>
extends CustomField<F> {
    private final Grid<V> grid;

    protected AbstractGridSelect(Grid<V> underlyingGrid) {
        this.grid = underlyingGrid;
        this.configureGrid(this.grid);
        this.setSizeFull();
    }

    protected void configureGrid(Grid<V> grid) {
        this.add(new Component[]{grid});
        this.grid.addSelectionListener(this::onGridSelected);
        this.grid.addFocusListener((ComponentEventListener & Serializable)gridFocusEvent -> this.fireEvent((ComponentEvent)new FocusNotifier.FocusEvent((Component)this, gridFocusEvent.isFromClient())));
        this.grid.addBlurListener((ComponentEventListener & Serializable)gridBlurEvent -> this.fireEvent((ComponentEvent)new BlurNotifier.BlurEvent((Component)this, gridBlurEvent.isFromClient())));
        this.grid.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(this.grid, (SerializableConsumer & Serializable)executionContext -> this.grid.getElement().executeJs("this.$.table.addEventListener('click', function(e) {this.preventSelection && e.stopPropagation()}.bind(this)); this.$.table.addEventListener('keydown', function(e){this.preventSelection && e.keyCode === 32 && e.stopPropagation()}.bind(this));", new Serializable[0])));
        grid.addClassName("grid-select-inner-grid");
    }

    protected void onGridSelected(SelectionEvent<Grid<V>, V> event) {
        this.updateValue();
    }

    public Grid<V> getGrid() {
        return this.grid;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.grid.getElement().setProperty("preventSelection", readOnly);
    }

    public void setEnabled(boolean enabled) {
        this.grid.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.grid.isEnabled();
    }
}

