/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.itemgrid;

import com.vaadin.flow.component.Component;
import java.io.Serializable;
import java.util.Objects;

public class CellInformation<T>
implements Serializable {
    private static final long serialVersionUID = 20210120L;
    private final int row;
    private final int column;
    private final transient T value;
    private final Component component;
    private final boolean valueCell;

    public CellInformation(int row, int column, T value, Component component) {
        this.row = row;
        this.column = column;
        this.value = value;
        this.component = component;
        this.valueCell = true;
    }

    public CellInformation(int row, int column, Component component) {
        this.row = row;
        this.column = column;
        this.value = null;
        this.component = component;
        this.valueCell = false;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public T getValue() {
        return this.value;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isValueCell() {
        return this.valueCell;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellInformation that = (CellInformation)o;
        return this.getRow() == that.getRow() && this.getColumn() == that.getColumn() && this.isValueCell() == that.isValueCell() && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getComponent(), that.getComponent());
    }

    public int hashCode() {
        return Objects.hash(this.getRow(), this.getColumn(), this.getValue(), this.getComponent(), this.isValueCell());
    }

    public String toString() {
        return "CellInformation{row=" + this.row + ", column=" + this.column + ", value=" + String.valueOf(this.value) + ", component=" + String.valueOf(this.component) + ", valueCell=" + this.valueCell + "}";
    }
}

