/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.itemgrid;

import java.util.Objects;
import org.vaadin.miki.superfields.itemgrid.CellInformation;

public class CellSelectionEvent<T> {
    private final CellInformation<T> cellInformation;
    private final boolean selected;

    public CellSelectionEvent(CellInformation<T> information, boolean selected) {
        this.cellInformation = information;
        this.selected = selected;
    }

    public CellSelectionEvent<T> reversed() {
        return new CellSelectionEvent<T>(this.cellInformation, !this.isSelected());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public CellInformation<T> getCellInformation() {
        return this.cellInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellSelectionEvent that = (CellSelectionEvent)o;
        return this.isSelected() == that.isSelected() && this.getCellInformation().equals(that.getCellInformation());
    }

    public int hashCode() {
        return Objects.hash(this.getCellInformation(), this.isSelected());
    }

    public String toString() {
        return "CellSelectionEvent{cellInformation=" + String.valueOf(this.cellInformation) + ", selected=" + this.selected + "}";
    }
}

