/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.lazyload;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.vaadin.miki.markers.WithIdMixin;
import org.vaadin.miki.markers.WithValueMixin;
import org.vaadin.miki.superfields.lazyload.ComponentObservationEvent;
import org.vaadin.miki.superfields.lazyload.ComponentObserver;

public class ObservedField
extends Composite<ObservedFieldElement>
implements HasStyle,
WithValueMixin<AbstractField.ComponentValueChangeEvent<ObservedField, Boolean>, Boolean, ObservedField>,
WithIdMixin<ObservedField> {
    public static final String REQUIRED_INDICATOR_VISIBLE = "required-indicator-visible";
    private final ArrayList<HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<ObservedField, Boolean>>> listeners = new ArrayList();
    private final boolean onlyToggleOnce;
    private boolean value = false;
    private boolean readOnly = false;

    public ObservedField() {
        this(false);
    }

    public ObservedField(HasValue.ValueChangeListener<HasValue.ValueChangeEvent<Boolean>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public ObservedField(boolean onlyToggleOnce) {
        this.onlyToggleOnce = onlyToggleOnce;
        this.addClassName(this.getClass().getSimpleName().toLowerCase());
        ((ObservedFieldElement)this.getContent()).addComponentObservationListener(this::onComponentObserved);
        ((ObservedFieldElement)this.getContent()).addDetachListener(this::onObserverDetached);
        ((ObservedFieldElement)this.getContent()).addAttachListener(this::onObserverAttached);
        ((ObservedFieldElement)this.getContent()).observe(new Component[]{this});
    }

    public ObservedField(boolean onlyToggleOnce, HasValue.ValueChangeListener<HasValue.ValueChangeEvent<Boolean>> listener) {
        this(onlyToggleOnce);
        this.addValueChangeListener(listener);
    }

    private void onComponentObserved(ComponentObservationEvent event) {
        this.setValue(event.isFullyVisible());
        if (event.isFullyVisible() && this.onlyToggleOnce) {
            ((ComponentObserver)event.getSource()).unobserve(new Component[]{this});
        }
    }

    private void onObserverAttached(AttachEvent attachEvent) {
        if (!((ObservedFieldElement)this.getContent()).isObserving((Component)this)) {
            ((ObservedFieldElement)this.getContent()).observe(new Component[]{this});
        }
    }

    private void onObserverDetached(DetachEvent event) {
        this.setValue(false);
    }

    protected void fireValueChangeEvent(boolean currentValue) {
        AbstractField.ComponentValueChangeEvent event = new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, (Object)(!currentValue ? 1 : 0), false);
        this.listeners.forEach((Consumer<HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<ObservedField, Boolean>>>)((Consumer<HasValue.ValueChangeListener>)listener -> listener.valueChanged((HasValue.ValueChangeEvent)event)));
    }

    public void setValue(Boolean aBoolean) {
        if (!this.isReadOnly() && !aBoolean.equals(this.value)) {
            this.value = aBoolean;
            this.fireValueChangeEvent(this.value);
        }
    }

    public Boolean getValue() {
        return this.value;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<ObservedField, Boolean>> valueChangeListener) {
        this.listeners.add(valueChangeListener);
        return (Registration & Serializable)() -> this.listeners.remove(valueChangeListener);
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setRequiredIndicatorVisible(boolean visible) {
        if (visible) {
            this.addClassName(REQUIRED_INDICATOR_VISIBLE);
        } else {
            this.removeClassName(REQUIRED_INDICATOR_VISIBLE);
        }
    }

    public boolean isRequiredIndicatorVisible() {
        return this.getClassNames().contains((Object)REQUIRED_INDICATOR_VISIBLE);
    }

    @Tag(value="observed-field")
    @JsModule(value="./observed-field.js")
    public static final class ObservedFieldElement
    extends ComponentObserver {
        public ObservedFieldElement() {
            super(new double[0]);
        }
    }
}

