/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object;

import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.vaadin.miki.superfields.object.PropertyMetadata;

public class Property<T, P> {
    private final String name;
    private final Class<T> owner;
    private final Class<P> type;
    private final SerializableBiConsumer<T, P> setter;
    private final SerializableFunction<T, P> getter;
    private final Map<String, PropertyMetadata> metadata;

    public Property(Class<T> owner, String name, Class<P> type, SerializableBiConsumer<T, P> setter, SerializableFunction<T, P> getter, PropertyMetadata ... metadata) {
        this(owner, name, type, setter, getter, metadata.length == 0 ? Collections.emptySet() : Set.of(metadata));
    }

    public Property(Class<T> owner, String name, Class<P> type, SerializableBiConsumer<T, P> setter, SerializableFunction<T, P> getter, Collection<PropertyMetadata> metadata) {
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.setter = setter;
        this.getter = getter;
        this.metadata = metadata.stream().collect(Collectors.toMap(PropertyMetadata::getName, Function.identity()));
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getOwner() {
        return this.owner;
    }

    public Optional<SerializableBiConsumer<T, P>> getSetter() {
        return Optional.ofNullable(this.setter);
    }

    public Optional<SerializableFunction<T, P>> getGetter() {
        return Optional.ofNullable(this.getter);
    }

    public Class<P> getType() {
        return this.type;
    }

    public Map<String, PropertyMetadata> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property that = (Property)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getOwner(), that.getOwner()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getSetter(), that.getSetter()) && Objects.equals(this.getGetter(), that.getGetter()) && Objects.equals(this.getMetadata(), that.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getOwner(), this.getType(), this.getSetter(), this.getGetter(), this.getMetadata());
    }

    public String toString() {
        return "ObjectPropertyDefinition{name='" + this.name + "', owner=" + String.valueOf(this.owner) + ", type=" + String.valueOf(this.type) + ", setter=" + String.valueOf(this.setter) + ", getter=" + String.valueOf(this.getter) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }
}

