/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.object;

import java.util.Objects;

public class PropertyMetadata {
    private final String name;
    private final Class<?> valueType;
    private final Object value;

    public <V> PropertyMetadata(String name, Class<V> valueType, V value) {
        this.name = name;
        this.valueType = valueType;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasValueOfType(Class<?> type) {
        return type.isInstance(this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyMetadata that = (PropertyMetadata)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getValueType(), that.getValueType()) && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getValueType(), this.getValue());
    }

    public String toString() {
        return "ObjectPropertyMetadata{name='" + this.name + "', valueType=" + String.valueOf(this.valueType) + ", value=" + String.valueOf(this.value) + "}";
    }
}

