/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.util;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StringTools {
    private static final String CAMEL_CASE_REGEXP = String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z_])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z_])");

    public static String firstLetterUppercase(String string) {
        return string == null || string.isEmpty() ? string : string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    public static String humanReadable(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return StringTools.firstLetterUppercase(string.replaceAll(CAMEL_CASE_REGEXP, " ").replaceAll("\\s{2,}", " ").trim());
    }

    public static Set<Character> toCharacterSet(char ... chars) {
        return IntStream.range(0, chars.length).mapToObj(index -> Character.valueOf(chars[index])).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private StringTools() {
    }
}

