/*
 * Decompiled with CFR 0.152.
 */
package pl.wendigo.chrome;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.reactivex.Observable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.wendigo.chrome.DeserializationFailed;
import pl.wendigo.chrome.ProtocolEvent;
import pl.wendigo.chrome.RequestFailed;
import pl.wendigo.chrome.RequestFrame;
import pl.wendigo.chrome.ResponseFrame;
import pl.wendigo.chrome.SerializationFailed;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0000\u00a2\u0006\u0004\b\t\u0010\nJ3\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00040\f\"\b\b\u0000\u0010\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0000\u00a2\u0006\u0002\b\u0010J7\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00040\f\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0000\u00a2\u0006\u0002\b\u0014J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0016\u00a8\u0006\u0018"}, d2={"Lpl/wendigo/chrome/FrameMapper;", "", "()V", "deserialize", "T", "text", "", "clazz", "Ljava/lang/Class;", "deserialize$chrome_reactive_kotlin_main", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeEvent", "Lio/reactivex/Observable;", "Lpl/wendigo/chrome/ProtocolEvent;", "responseFrame", "Lpl/wendigo/chrome/ResponseFrame;", "deserializeEvent$chrome_reactive_kotlin_main", "deserializeResponse", "requestFrame", "Lpl/wendigo/chrome/RequestFrame;", "deserializeResponse$chrome_reactive_kotlin_main", "serialize", "serialize$chrome_reactive_kotlin_main", "Companion", "chrome-reactive-kotlin_main"})
public final class FrameMapper {
    private static final ObjectMapper mapper;
    public static final Companion Companion;

    @NotNull
    public final Observable<String> serialize$chrome_reactive_kotlin_main(@NotNull RequestFrame requestFrame) {
        Intrinsics.checkParameterIsNotNull((Object)requestFrame, (String)"requestFrame");
        try {
            Observable observable = Observable.just((Object)FrameMapper.Companion.getMapper().writeValueAsString((Object)requestFrame));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.just(mapper.w\u2026ueAsString(requestFrame))");
            return observable;
        }
        catch (Exception e) {
            Observable observable = Observable.error((Throwable)new SerializationFailed("Could not serialize request frame", e));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.error(Seriali\u2026alize request frame\", e))");
            return observable;
        }
    }

    @NotNull
    public final <T> Observable<T> deserializeResponse$chrome_reactive_kotlin_main(@NotNull RequestFrame requestFrame, @NotNull ResponseFrame responseFrame, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)requestFrame, (String)"requestFrame");
        Intrinsics.checkParameterIsNotNull((Object)responseFrame, (String)"responseFrame");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (responseFrame.getError() != null) {
            Observable observable = Observable.error((Throwable)new RequestFailed(requestFrame, responseFrame.getError().getMessage()));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.error(Request\u2026onseFrame.error.message))");
            return observable;
        }
        try {
            if (Intrinsics.areEqual(clazz, ResponseFrame.class)) {
                Observable observable = Observable.just((Object)responseFrame);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.just(responseFrame as T)");
                return observable;
            }
            Observable observable = Observable.just((Object)FrameMapper.Companion.getMapper().treeToValue((TreeNode)responseFrame.getResult(), clazz));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.just(mapper.t\u2026onseFrame.result, clazz))");
            return observable;
        }
        catch (Exception ex) {
            Observable observable = Observable.error((Throwable)new DeserializationFailed("Could not deserialize response frame", ex));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.error(Deseria\u2026ize response frame\", ex))");
            return observable;
        }
    }

    public final <T> T deserialize$chrome_reactive_kotlin_main(@NotNull String text, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return (T)FrameMapper.Companion.getMapper().readValue(text, clazz);
    }

    @NotNull
    public final <T extends ProtocolEvent> Observable<T> deserializeEvent$chrome_reactive_kotlin_main(@NotNull ResponseFrame responseFrame, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)responseFrame, (String)"responseFrame");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            if (Intrinsics.areEqual(clazz, ProtocolEvent.class)) {
                String string = responseFrame.getMethod();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Observable observable = Observable.just((Object)ProtocolEvent.Companion.fromMethodName$chrome_reactive_kotlin_main(string));
                if (observable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.reactivex.Observable<T>");
                }
                return observable;
            }
            Observable observable = Observable.just((Object)FrameMapper.Companion.getMapper().treeToValue((TreeNode)responseFrame.getParams(), clazz));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.just(mapper.t\u2026onseFrame.params, clazz))");
            return observable;
        }
        catch (Exception e) {
            Observable observable = Observable.error((Throwable)new DeserializationFailed("Could not deserialize event", e));
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.error(Deseria\u2026t deserialize event\", e))");
            return observable;
        }
    }

    static {
        Companion = new Companion(null);
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, 1, null)).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper().registerM\u2026NKNOWN_PROPERTIES, false)");
        mapper = objectMapper;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lpl/wendigo/chrome/FrameMapper$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "chrome-reactive-kotlin_main"})
    public static final class Companion {
        private final ObjectMapper getMapper() {
            return mapper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

