/*
 * Decompiled with CFR 0.152.
 */
package pl.wendigo.chrome;

import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Timed;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wendigo.chrome.ChromeProtocol;
import pl.wendigo.chrome.FrameMapper;
import pl.wendigo.chrome.FramesStream;
import pl.wendigo.chrome.HeadlessSession;
import pl.wendigo.chrome.RequestFrame;
import pl.wendigo.chrome.ResponseFrame;
import pl.wendigo.chrome.TargetedFramesStream;
import pl.wendigo.chrome.domain.target.CloseTargetRequest;
import pl.wendigo.chrome.domain.target.CloseTargetResponse;
import pl.wendigo.chrome.domain.target.DisposeBrowserContextRequest;
import pl.wendigo.chrome.domain.target.DisposeBrowserContextResponse;
import pl.wendigo.chrome.domain.target.ReceivedMessageFromTargetEvent;
import pl.wendigo.chrome.domain.target.SendMessageToTargetRequest;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0016J0\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\r0\u0011\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\u0006\u0010\u0019\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/wendigo/chrome/TargetedFramesStream;", "Lpl/wendigo/chrome/FramesStream;", "mapper", "Lpl/wendigo/chrome/FrameMapper;", "api", "Lpl/wendigo/chrome/ChromeProtocol;", "session", "Lpl/wendigo/chrome/HeadlessSession;", "(Lpl/wendigo/chrome/FrameMapper;Lpl/wendigo/chrome/ChromeProtocol;Lpl/wendigo/chrome/HeadlessSession;)V", "close", "", "eventFrames", "Lio/reactivex/Observable;", "Lio/reactivex/schedulers/Timed;", "Lpl/wendigo/chrome/ResponseFrame;", "frames", "getResponse", "Lio/reactivex/Single;", "T", "requestFrame", "Lpl/wendigo/chrome/RequestFrame;", "clazz", "Ljava/lang/Class;", "send", "", "frame", "Companion", "chrome-reactive-kotlin_main"})
public final class TargetedFramesStream
implements FramesStream {
    private final FrameMapper mapper;
    private final ChromeProtocol api;
    private final HeadlessSession session;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public <T> Single<Timed<T>> getResponse(@NotNull RequestFrame requestFrame, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)requestFrame, (String)"requestFrame");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Single single = this.frames().filter((Predicate)new Predicate<Timed<ResponseFrame>>(requestFrame){
            final /* synthetic */ RequestFrame $requestFrame;

            public final boolean test(@NotNull Timed<ResponseFrame> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return ((ResponseFrame)it.value()).isResponse$chrome_reactive_kotlin_main(this.$requestFrame.getId());
            }
            {
                this.$requestFrame = requestFrame;
            }
        }).flatMapSingle(new Function<T, SingleSource<? extends R>>(this, requestFrame, clazz){
            final /* synthetic */ TargetedFramesStream this$0;
            final /* synthetic */ RequestFrame $requestFrame;
            final /* synthetic */ Class $clazz;

            public final Single<Timed<T>> apply(@NotNull Timed<ResponseFrame> frame) {
                Intrinsics.checkParameterIsNotNull(frame, (String)"frame");
                FrameMapper frameMapper = TargetedFramesStream.access$getMapper$p(this.this$0);
                Object object = frame.value();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"frame.value()");
                return frameMapper.deserializeResponse$chrome_reactive_kotlin_main(this.$requestFrame, (ResponseFrame)object, this.$clazz).map((Function)new Function<T, R>(frame){
                    final /* synthetic */ Timed $frame;

                    @NotNull
                    public final Timed<T> apply(T it) {
                        return new Timed(it, this.$frame.time(), this.$frame.unit());
                    }
                    {
                        this.$frame = timed;
                    }
                });
            }
            {
                this.this$0 = targetedFramesStream;
                this.$requestFrame = requestFrame;
                this.$clazz = clazz;
            }
        }).take(1L).singleOrError();
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"frames().filter {\n      \u2026\n        .singleOrError()");
        return single;
    }

    @Override
    @NotNull
    public Single<Boolean> send(@NotNull RequestFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Single single = this.mapper.serialize$chrome_reactive_kotlin_main(frame).flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ TargetedFramesStream this$0;

            public final Single<Boolean> apply(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                String string = message;
                String string2 = TargetedFramesStream.access$getSession$p(this.this$0).getTargetId();
                String string3 = TargetedFramesStream.access$getSession$p(this.this$0).getSessionId();
                return TargetedFramesStream.access$getApi$p(this.this$0).getTarget().sendMessageToTarget(new SendMessageToTargetRequest(string, string3, string2)).map((Function)send.1.INSTANCE);
            }
            {
                this.this$0 = targetedFramesStream;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"mapper.serialize(frame).\u2026.isResponse() }\n        }");
        return single;
    }

    @Override
    @NotNull
    public Observable<Timed<ResponseFrame>> eventFrames() {
        Observable observable = this.frames().filter((Predicate)eventFrames.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"frames().filter {\n      \u2026t.value().isEvent()\n    }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<Timed<ResponseFrame>> frames() {
        Observable observable = this.api.getTarget().receivedMessageFromTargetTimed().filter((Predicate)new Predicate<Timed<ReceivedMessageFromTargetEvent>>(this){
            final /* synthetic */ TargetedFramesStream this$0;

            public final boolean test(@NotNull Timed<ReceivedMessageFromTargetEvent> message) {
                Intrinsics.checkParameterIsNotNull(message, (String)"message");
                Object object = message.value();
                ReceivedMessageFromTargetEvent $receiver = (ReceivedMessageFromTargetEvent)object;
                return Intrinsics.areEqual((Object)$receiver.getSessionId(), (Object)TargetedFramesStream.access$getSession$p(this.this$0).getSessionId()) || Intrinsics.areEqual((Object)$receiver.getTargetId(), (Object)TargetedFramesStream.access$getSession$p(this.this$0).getTargetId());
            }
            {
                this.this$0 = targetedFramesStream;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ TargetedFramesStream this$0;

            @NotNull
            public final Timed<ResponseFrame> apply(@NotNull Timed<ReceivedMessageFromTargetEvent> frame) {
                Intrinsics.checkParameterIsNotNull(frame, (String)"frame");
                return new Timed((Object)TargetedFramesStream.access$getMapper$p(this.this$0).deserialize$chrome_reactive_kotlin_main(((ReceivedMessageFromTargetEvent)frame.value()).getMessage(), ResponseFrame.class), frame.time(), frame.unit());
            }
            {
                this.this$0 = targetedFramesStream;
            }
        }).toObservable();
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"api.Target.receivedMessa\u2026}\n        .toObservable()");
        return observable;
    }

    @Override
    public void close() {
        try {
            DisposeBrowserContextResponse response2 = (DisposeBrowserContextResponse)this.api.getTarget().closeTarget(new CloseTargetRequest(this.session.getTargetId())).flatMap(new Function<T, SingleSource<? extends R>>(this){
                final /* synthetic */ TargetedFramesStream this$0;

                @NotNull
                public final Single<DisposeBrowserContextResponse> apply(@NotNull CloseTargetResponse it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return TargetedFramesStream.access$getApi$p(this.this$0).getTarget().disposeBrowserContext(new DisposeBrowserContextRequest(TargetedFramesStream.access$getSession$p(this.this$0).getBrowserContextId()));
                }
                {
                    this.this$0 = targetedFramesStream;
                }
            }).blockingGet();
            Companion.getLogger().info("Closed session {} with status {}", (Object)this.session, (Object)response2);
            this.api.close();
        }
        catch (Exception e) {
            Companion.getLogger().info("Could not close target due to exception " + e.getMessage());
        }
    }

    public TargetedFramesStream(@NotNull FrameMapper mapper, @NotNull ChromeProtocol api, @NotNull HeadlessSession session) {
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.mapper = mapper;
        this.api = api;
        this.session = session;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(TargetedFramesStream.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        TargetedFramesStream.logger = logger;
    }

    @NotNull
    public static final /* synthetic */ FrameMapper access$getMapper$p(TargetedFramesStream $this) {
        return $this.mapper;
    }

    @NotNull
    public static final /* synthetic */ ChromeProtocol access$getApi$p(TargetedFramesStream $this) {
        return $this.api;
    }

    @NotNull
    public static final /* synthetic */ HeadlessSession access$getSession$p(TargetedFramesStream $this) {
        return $this.session;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lpl/wendigo/chrome/TargetedFramesStream$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "chrome-reactive-kotlin_main"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

