/*
 * Decompiled with CFR 0.152.
 */
package pl.wendigo.chrome;

import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.schedulers.Timed;
import io.reactivex.subjects.Subject;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wendigo.chrome.FrameMapper;
import pl.wendigo.chrome.FramesStream;
import pl.wendigo.chrome.RequestFrame;
import pl.wendigo.chrome.ResponseFrame;
import pl.wendigo.chrome.WebsocketFramesStream;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B3\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0016J0\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00070\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001bH\u0016J$\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0016J&\u0010!\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001c\u0010&\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u0004H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00162\u0006\u0010*\u001a\u00020\u0019H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lpl/wendigo/chrome/WebsocketFramesStream;", "Lokhttp3/WebSocketListener;", "Lpl/wendigo/chrome/FramesStream;", "uri", "", "messages", "Lio/reactivex/subjects/Subject;", "Lio/reactivex/schedulers/Timed;", "Lpl/wendigo/chrome/ResponseFrame;", "mapper", "Lpl/wendigo/chrome/FrameMapper;", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lio/reactivex/subjects/Subject;Lpl/wendigo/chrome/FrameMapper;Lokhttp3/OkHttpClient;)V", "connection", "Lokhttp3/WebSocket;", "close", "", "eventFrames", "Lio/reactivex/Observable;", "frames", "getResponse", "Lio/reactivex/Single;", "T", "requestFrame", "Lpl/wendigo/chrome/RequestFrame;", "clazz", "Ljava/lang/Class;", "onClosed", "webSocket", "code", "", "reason", "onFailure", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "send", "", "frame", "Companion", "chrome-reactive-kotlin_main"})
public final class WebsocketFramesStream
extends WebSocketListener
implements FramesStream {
    private final Subject<Timed<ResponseFrame>> messages;
    private final FrameMapper mapper;
    private final WebSocket connection;
    private final OkHttpClient client;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    public void onMessage(@Nullable WebSocket webSocket, @Nullable String text) {
        String string = text;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.messages.onNext((Object)new Timed((Object)this.mapper.deserialize$chrome_reactive_kotlin_main(string, ResponseFrame.class), System.currentTimeMillis(), TimeUnit.MILLISECONDS));
    }

    public void onClosed(@Nullable WebSocket webSocket, int code, @Nullable String reason) {
        this.messages.onComplete();
    }

    public void onFailure(@Nullable WebSocket webSocket, @Nullable Throwable t, @Nullable Response response2) {
        this.messages.onComplete();
    }

    @Override
    @NotNull
    public <T> Single<Timed<T>> getResponse(@NotNull RequestFrame requestFrame, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)requestFrame, (String)"requestFrame");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Single single = this.frames().filter((Predicate)new Predicate<Timed<ResponseFrame>>(requestFrame){
            final /* synthetic */ RequestFrame $requestFrame;

            public final boolean test(@NotNull Timed<ResponseFrame> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return ((ResponseFrame)it.value()).isResponse$chrome_reactive_kotlin_main(this.$requestFrame.getId());
            }
            {
                this.$requestFrame = requestFrame;
            }
        }).flatMapSingle(new Function<T, SingleSource<? extends R>>(this, requestFrame, clazz){
            final /* synthetic */ WebsocketFramesStream this$0;
            final /* synthetic */ RequestFrame $requestFrame;
            final /* synthetic */ Class $clazz;

            public final Single<Timed<T>> apply(@NotNull Timed<ResponseFrame> frame) {
                Intrinsics.checkParameterIsNotNull(frame, (String)"frame");
                FrameMapper frameMapper = WebsocketFramesStream.access$getMapper$p(this.this$0);
                Object object = frame.value();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"frame.value()");
                return frameMapper.deserializeResponse$chrome_reactive_kotlin_main(this.$requestFrame, (ResponseFrame)object, this.$clazz).map((Function)new Function<T, R>(frame){
                    final /* synthetic */ Timed $frame;

                    @NotNull
                    public final Timed<T> apply(T it) {
                        return new Timed(it, this.$frame.time(), this.$frame.unit());
                    }
                    {
                        this.$frame = timed;
                    }
                });
            }
            {
                this.this$0 = websocketFramesStream;
                this.$requestFrame = requestFrame;
                this.$clazz = clazz;
            }
        }).subscribeOn(Schedulers.io()).take(1L).singleOrError();
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"frames()\n            .fi\u2026         .singleOrError()");
        return single;
    }

    @Override
    @NotNull
    public Single<Boolean> send(@NotNull RequestFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Single single = Single.just((Object)frame).flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ WebsocketFramesStream this$0;

            @NotNull
            public final Single<String> apply(@NotNull RequestFrame it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return WebsocketFramesStream.access$getMapper$p(this.this$0).serialize$chrome_reactive_kotlin_main(it);
            }
            {
                this.this$0 = websocketFramesStream;
            }
        }).map(new Function<T, R>(this){
            final /* synthetic */ WebsocketFramesStream this$0;

            public final boolean apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return WebsocketFramesStream.access$getConnection$p(this.this$0).send(it);
            }
            {
                this.this$0 = websocketFramesStream;
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single\n            .just\u2026scribeOn(Schedulers.io())");
        return single;
    }

    @Override
    @NotNull
    public Observable<Timed<ResponseFrame>> eventFrames() {
        Observable observable = this.frames().filter((Predicate)eventFrames.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"frames().filter {\n      \u2026t.value().isEvent()\n    }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<Timed<ResponseFrame>> frames() {
        return (Observable)this.messages;
    }

    @Override
    public void close() {
        try {
            this.connection.close(1000, "Goodbye!");
            this.connection.cancel();
            this.client.connectionPool().evictAll();
        }
        catch (Exception e) {
            Companion.getLogger().warn("caught exception while closing: " + e.getMessage());
        }
        try {
            this.messages.onComplete();
        }
        catch (Exception e) {
            Companion.getLogger().warn("caught exception while completing subject: " + e.getMessage());
        }
    }

    public WebsocketFramesStream(@NotNull String uri, @NotNull Subject<Timed<ResponseFrame>> messages, @NotNull FrameMapper mapper, @NotNull OkHttpClient client2) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
        this.messages = messages;
        this.mapper = mapper;
        this.client = client2;
        WebSocket webSocket = client2.newWebSocket(new Request.Builder().url(uri).build(), (WebSocketListener)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)webSocket, (String)"client.newWebSocket(Requ\u2026).url(uri).build(), this)");
        this.connection = webSocket;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(WebsocketFramesStream.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        WebsocketFramesStream.logger = logger;
    }

    @NotNull
    public static final /* synthetic */ FrameMapper access$getMapper$p(WebsocketFramesStream $this) {
        return $this.mapper;
    }

    @NotNull
    public static final /* synthetic */ WebSocket access$getConnection$p(WebsocketFramesStream $this) {
        return $this.connection;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lpl/wendigo/chrome/WebsocketFramesStream$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "chrome-reactive-kotlin_main"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

