package plus.easydo.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import plus.easydo.api.factory.FileStoreFallback;
import plus.easydo.api.vo.FileStoreVo;
import plus.easydo.core.result.R;
import plus.easydo.starter.web.core.config.MultipartSupportConfig;

/**
 * @author yuzhanfeng
 */
@FeignClient(name = "file-store",path = "/file", configuration = {MultipartSupportConfig.class},fallback = FileStoreFallback.class)
public interface FileStoreFeignClient {

    /**
     * 文件上传
     *
     * @param file file
     * @param fileName fileName
     * @param filePath filePath
     * @param bucketName bucketName
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
    @PostMapping(value = "",consumes = MediaType.MULTIPART_FORM_DATA_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    R<FileStoreVo> saveFile(@RequestPart("file") MultipartFile file,
                            @RequestParam(name = "fileName", required = false) String fileName,
                            @RequestParam(name = "filePath", required = false) String filePath,
                            @RequestParam(name = "bucketName", required = false)String bucketName);

    /**
     * 从文件存储中直接删除文件
     *
     * @param bucketName bucketName
     * @param fileName fileName
     * @param filePath filePath
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
    @PostMapping("/remove")
    public R<Object> remove(@RequestParam(name = "bucketName", required = false)String bucketName,
                            @RequestParam(name = "fileName", required = false) String fileName,
                            @RequestParam(name = "filePath", required = false) String filePath);

}
