package plus.easydo.api;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import plus.easydo.api.factory.UserServiceFallbackFactory;
import plus.easydo.api.model.SysUser;
import plus.easydo.core.result.R;
import plus.easydo.starter.oauth.client.anotation.OauthFeignClient;

/**
 * @author yuzhanfeng
 */
@OauthFeignClient(name = "user-center",path = "/user", fallbackFactory = UserServiceFallbackFactory.class)
public interface UserServiceFeignClient {

    /**
     * 根据用户名查询用户信息
     * @param userName userName
     * @author yuzhanfeng
     * @return 用户信息
     */
    @RequestMapping("/findByUserName")
    R<SysUser> findByUserName(@RequestParam(name = "userName",defaultValue = "")String userName);

}
