package plus.easydo.api.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 文件存储数据展示对象
 * 
 * @author gebilaoyu
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
public class FileStoreVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 自增主键 */
    private Long id;

    /** 文件名 */
    private String fileName;

    /** 路径 */
    private String filePath;

    /** 文件大小/kb */
    private BigDecimal fileSize;

    /** 存储桶 */
    private String bucketName;

    /** 拼接好的路径 */
    private String url;

}
