package plus.easydo.starter.web.core.annotation;

import org.springframework.cloud.openfeign.EnableFeignClients;
import plus.easydo.starter.web.core.interceptor.CustomizeFeignClientInterceptor;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 扩展EnableFeignClients注解 添加全局base
 *
 * @author yuzhanfeng
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@EnableFeignClients
public @interface EasyDoEnableOpenFeignClients {
    String[] value() default {};

    String[] basePackages() default {"plus.easydo"};

    Class<?>[] basePackageClasses() default {};

    Class<?>[] defaultConfiguration() default {CustomizeFeignClientInterceptor.class};

    Class<?>[] clients() default {};
}
