package plus.easydo.starter.web.core.config;

import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 表单提交支持
 *
 * @author laoyu
 */
@Configuration
public class MultipartSupportConfig {


	@Autowired
	private ObjectFactory<HttpMessageConverters> messageConverters;

	/**
	 * new一个form编码器，实现支持form表单提交
	 *
	 */
	@Bean
	public Encoder feignFormEncoder() {
		return new SpringFormEncoder(new SpringEncoder(messageConverters));
	}


}