/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.web.core.handler;

import cn.hutool.core.lang.Validator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import plus.easydo.core.exception.BaseException;
import plus.easydo.core.exception.CustomException;
import plus.easydo.core.exception.HasPermissionException;
import plus.easydo.core.result.DataResult;
import plus.easydo.core.result.R;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public R<Object> baseException(BaseException e) {
        return DataResult.fail((String)e.getDefaultMessage());
    }

    @ExceptionHandler(value={CustomException.class})
    public R<Object> businessException(CustomException e) {
        if (Validator.isNull((Object)e.getCode())) {
            return DataResult.fail((String)e.getMessage());
        }
        return DataResult.fail((Object)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public R<Object> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return DataResult.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public R<Object> validatedBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return DataResult.fail((String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object validExceptionHandler(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage();
        return DataResult.fail((String)message);
    }

    @ExceptionHandler(value={HasPermissionException.class})
    public Object validExceptionHandler(HasPermissionException e) {
        if (Validator.isNull((Object)e.getMessage())) {
            return DataResult.fail((int)403, (String)"\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\u3002");
        }
        return DataResult.fail((int)403, (String)e.getMessage());
    }
}

