package plus.easydo.starter.file.minio.service;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import plus.easydo.core.result.R;
import plus.easydo.starter.file.FileStoreObject;
import plus.easydo.starter.file.minio.MinioTemplate;
import plus.easydo.starter.file.exception.FileStoreException;
import plus.easydo.starter.file.service.CommonFileStoreServer;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author laoyu
 * @version 1.0
 */
@Service
public class MinioFileStoreServer extends CommonFileStoreServer<String, MultipartFile, InputStream, MinioTemplate> {


    @Override
    public R<Object> save(FileStoreObject<String, MultipartFile> fileStoreObject) {
        try {
            R<Object> result = super.save(fileStoreObject);
            InputStream in = file.getInputStream();
            String contentType = file.getContentType();
            if(!template.bucketExists(groupName)){
                template.createBucket(groupName);
            }
            template.putObject(groupName, filePath + fileName, in, file.getSize(), contentType);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            return fail();
        }
    }


    @Override
    public InputStream getFile(String groupName, String fileId) {
        if (StrUtil.isBlank(fileId)) {
            throw new FileStoreException("fileId is empty");
        }
        String[] ids = fileId.split(";");
        if (ids.length == 1) {
            try {
                return template.getObject(buildGroupName(groupName), fileId);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else if (ids.length == 2) {
            try {
                return getTemplate().getObject(ids[0], ids[1]);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new FileStoreException("File does not exist");
    }


    @Override
    public Boolean remove(String groupName, String fileId) {
        if (StrUtil.isBlank(fileId)) {
            throw new FileStoreException("fileId is empty");
        }
        if (StrUtil.isBlank(groupName)) {
            try {
                template.removeObject(template.getDefaultBucket(), fileId);
                return true;
            } catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        } else{
            try {
                template.removeObject(groupName, fileId);
                return true;
            } catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    @Override
    public FileStoreObject<String, MultipartFile> copy(String s, String s2) {
        return null;
    }

    @Override
    public FileStoreObject<String, MultipartFile> move(String s, String s2) {
        return null;
    }

    @Override
    public void validationFile(MultipartFile multipartFile) {
        super.validationFile(multipartFile);
        if (multipartFile.getSize() == 0) {
            throw new FileStoreException("fileId is empty");
        }
    }

    @Override
    public String buildFileName(MultipartFile file, String fileName) {
        String prefix = RandomUtil.randomNumbers(10)+"-";
        if (StrUtil.isBlank(fileName)) {
            fileName = file.getOriginalFilename();
        }
        return prefix + fileName;
    }

    @Override
    public String buildGroupName(String groupName) {
        if (StrUtil.isBlank(groupName)) {
            groupName = template.getDefaultBucket();
        }
        return groupName;
    }

    @Override
    public BigDecimal getFileKbSize(MultipartFile file) {
        // 首先先将.getSize()获取的Long转为String 然后将String转为Float并除以1024 （因为1KB=1024B）
        float size = Float.parseFloat(String.valueOf(file.getSize())) / 1024;
        // 四舍五入保留2位，
        return BigDecimal.valueOf(size).setScale(2, RoundingMode.HALF_UP);
    }

}
