package plus.easydo.starter.file.service;


import plus.easydo.core.result.R;
import plus.easydo.starter.file.FileResult;
import plus.easydo.starter.file.FileStoreObject;

import java.math.BigDecimal;

/**
 * 文件存储抽象接口
 * @author laoyu
 */
public interface FileStoreService<ID, INPUT_FILE, RESULT_FILE, TEMPLATE> {


    /**
     * 获得工具类
     *
     * @return TOOL
     * @author laoyu
     */
    TEMPLATE getTemplate();

    /**
     * 功能描述
     *
     * @param fileStoreObject 文件包装类
     * @return FILE 文件
     * @author laoyu
     */
    R<Object> save(FileStoreObject<ID, INPUT_FILE> fileStoreObject);


    /**
     * 获得文件
     *
     * @param id 文件唯一标识
     * @return 文件包装类
     * @author laoyu
     */
    RESULT_FILE getFile(String groupName, ID id);

    /**
     * 功能描述
     *
     * @param groupName 分组
     * @param id 文件标识
     * @return 是否删除成功
     * @author laoyu
     */
    Boolean remove(String groupName, ID id);


    /**
     * 复制文件
     *
     * @param id 已存在的文件标识
     * @param target 目标
     * @return 新的文件信息
     * @author laoyu
     */
    FileStoreObject<ID, INPUT_FILE> copy(ID id, String target);

    /**
     * 移动文件
     *
     * @param id id
     * @param target target
     * @return 新的文件信息
     * @author laoyu
     */
    FileStoreObject<ID, INPUT_FILE> move(ID id, String target);


    /**
     * 校验文件
     *
     * @param inputFile inputFile
     * @author laoyu
     */
    void validationFile(INPUT_FILE inputFile);

    /**
     * 构建文件路径
     *
     * @param filePath filePath
     * @return java.lang.String
     * @author laoyu
     */
    String buildFilePath(String filePath);

    /**
     * 构建文件名称
     *
     * @param inputFile inputFile
     * @param fileName fileName
     * @return java.lang.String
     * @author laoyu
     */
    String buildFileName(INPUT_FILE inputFile,String fileName);

    /**
     * 构建文件分组名称
     *
     * @param groupName groupName
     * @return java.lang.String
     * @author laoyu
     */
    String buildGroupName(String groupName);


    /**
     * 获得文件大小
     *
     * @param inputFile inputFile
     * @return java.math.BigDecimal
     * @author laoyu
     */
    BigDecimal getFileKbSize(INPUT_FILE inputFile);


    /**
     * 构建文件返回对象
     *
     * @return INPUT_FILE
     * @author laoyu
     */
    FileResult<ID> buildResult();






}
