package plus.easydo.starter.file;

import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.easydo.starter.file.local.LocalFileStoreService;
import plus.easydo.starter.file.local.LocalFileStoreTemplate;
import plus.easydo.starter.file.local.config.LocalFileProperties;
import plus.easydo.starter.file.minio.MinioFileStoreServer;
import plus.easydo.starter.file.minio.MinioTemplate;
import plus.easydo.starter.file.minio.config.MinioProperties;

/**
 * 文件服务的自动装配类，使用 @EnableFileStoreServer服务则走此流程
 *
 * @author laoyu
 * @version 1.0
 */
@Configuration
@EnableConfigurationProperties({MinioProperties.class, LocalFileProperties.class})
public class FileStoreAutoConfiguration {


    @Bean
    @ConditionalOnProperty(prefix = "easydo.file.local", name = "enable", havingValue = "true")
    public LocalFileStoreTemplate localFileStoreTemplate() {
        return new LocalFileStoreTemplate();
    }

    @Bean
    @ConditionalOnProperty(prefix = "easydo.file.local", name = "enable", havingValue = "true")
    public LocalFileStoreService localFileStoreService() {
        return new LocalFileStoreService();
    }

    @Autowired
    private MinioProperties minioProperties;

    /**
     * 功能描述
     *
     * @return io.minio.MinioClient
     * @author laoyu
     */
    @Bean
    @ConditionalOnProperty(prefix = "easydo.file.minio", name = "enable", havingValue = "true")
    public MinioClient minioClient() throws InvalidPortException, InvalidEndpointException {
        return new MinioClient(minioProperties.getServerAddress(), minioProperties.getAccessKey(), minioProperties.getSecretKey());
    }

    @Bean
    @ConditionalOnProperty(prefix = "easydo.file.minio", name = "enable", havingValue = "true")
    public MinioTemplate minioTemplate() {
        return new MinioTemplate();
    }

    @Bean
    @ConditionalOnProperty(prefix = "easydo.file.minio", name = "enable", havingValue = "true")
    public MinioFileStoreServer fileStoreService() {
        return new MinioFileStoreServer();
    }

}
