package plus.easydo.starter.file.local;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import plus.easydo.core.result.R;
import plus.easydo.starter.file.FileResult;
import plus.easydo.starter.file.FileStoreObject;
import plus.easydo.starter.file.FileStoreUtil;
import plus.easydo.starter.file.exception.FileStoreException;
import plus.easydo.starter.file.CommonFileStoreServer;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 本地文件存储实现
 *
 * @author laoyu
 * @version 1.0
 */
@Component
public class LocalFileStoreService extends CommonFileStoreServer<String, MultipartFile, InputStream, LocalFileStoreTemplate> {

    @Override
    public R<FileResult<String>> save(FileStoreObject<String, MultipartFile> fileStoreObject) {
        R<FileResult<String>> result = super.save(fileStoreObject);
        template.save(groupName,filePath,fileName,file);
        FileResult<String> resultFile = result.getData();
        resultFile.setIndex(FileStoreUtil.endWithSlash(groupName) + FileStoreUtil.endWithSlash(filePath) + fileName);
        resultFile.setUrl(FileStoreUtil.endWithSlash(groupName) + FileStoreUtil.endWithSlash(filePath) + fileName);
        result.setData(resultFile);
        return result;
    }

    @Override
    public InputStream getFile(String groupName, String fileIndex) {
        if (StrUtil.isBlank(fileIndex)) {
            throw new FileStoreException("fileId is empty");
        }
        return template.getFile(groupName, fileIndex);
    }

    @Override
    public Boolean remove(String groupName, String fileIndex) {
        return template.remove(groupName, fileIndex);
    }

    @Override
    public void copy(String groupName, String index, String targetGroupName, String targetIndex) {
         template.copy(groupName, index, targetGroupName, targetIndex);

    }

    @Override
    public void move(String groupName, String index, String targetGroupName, String targetIndex) {
        template.move(groupName, index, targetGroupName, targetIndex);
    }

    @Override
    public String buildFileName(MultipartFile file, String fileName) {
        String prefix = RandomUtil.randomNumbers(10) + "-"+ "local" + "-";
        if (StrUtil.isNotBlank(fileName) && !NULL.equals(fileName)) {
            return prefix + fileName;
        }else {
            String originalFilename = file.getOriginalFilename();
            if(StrUtil.isNotBlank(originalFilename)){
                return prefix + originalFilename;
            }
        }
        return prefix;
    }

    @Override
    public String buildGroupName(String groupName) {
        if (StrUtil.isBlank(groupName) || NULL.equals(groupName)) {
            groupName = template.getDefaultGroupName();
        }
        return groupName;
    }

    @Override
    public BigDecimal getFileKbSize(MultipartFile file) {
        // 首先先将.getSize()获取的Long转为String 然后将String转为Float并除以1024 （因为1KB=1024B）
        float size = Float.parseFloat(String.valueOf(file.getSize())) / 1024;
        // 四舍五入保留2位，
        return BigDecimal.valueOf(size).setScale(2, RoundingMode.HALF_UP);
    }
}
