/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import plus.easydo.core.result.DataResult;
import plus.easydo.core.result.R;
import plus.easydo.starter.file.FileResult;
import plus.easydo.starter.file.FileStoreObject;
import plus.easydo.starter.file.FileStoreService;
import plus.easydo.starter.file.exception.FileStoreException;

public abstract class CommonFileStoreServer<INDEX, INPUT_FILE, RESULT_FILE, TEMPLATE>
extends DataResult<Object>
implements FileStoreService<INDEX, INPUT_FILE, RESULT_FILE, TEMPLATE> {
    protected static final String SLASH = "/";
    protected static final String NULL = "null";
    protected FileStoreObject<INDEX, INPUT_FILE> fileStoreObject;
    protected INPUT_FILE file;
    protected String filePath;
    protected String fileName;
    protected String groupName;
    protected BigDecimal fileKbSize;
    @Autowired
    protected TEMPLATE template;

    @Override
    public TEMPLATE getTemplate() {
        return this.template;
    }

    @Override
    public R<FileResult<INDEX>> save(FileStoreObject<INDEX, INPUT_FILE> fileStoreObject) {
        this.validationFile(fileStoreObject.getFile());
        this.fileStoreObject = fileStoreObject;
        this.file = fileStoreObject.getFile();
        this.fileName = this.buildFileName(fileStoreObject.getFile(), fileStoreObject.getFileName());
        this.filePath = this.buildFilePath(fileStoreObject.getFilePath());
        this.groupName = this.buildGroupName(fileStoreObject.getGroupName());
        this.fileKbSize = this.getFileKbSize(this.file);
        return CommonFileStoreServer.ok(this.buildResult());
    }

    @Override
    public void validationFile(INPUT_FILE inputFile) {
        if (Objects.isNull(inputFile)) {
            throw new FileStoreException("file is empty");
        }
    }

    @Override
    public String buildFilePath(String filePath) {
        if (StrUtil.isBlank((CharSequence)filePath) || NULL.equals(filePath)) {
            filePath = LocalDateTimeUtil.format((LocalDateTime)LocalDateTimeUtil.now(), (String)"yyyyMMdd") + SLASH;
        } else if (filePath.endsWith(SLASH)) {
            filePath = filePath + SLASH;
        }
        return filePath;
    }

    @Override
    public FileResult<INDEX> buildResult() {
        FileResult result = new FileResult();
        result.setGroupName(this.groupName);
        result.setFileName(this.fileName);
        result.setFilePath(this.filePath);
        result.setFileSize(this.fileKbSize);
        return result;
    }
}

