/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file.local;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import plus.easydo.core.result.R;
import plus.easydo.starter.file.CommonFileStoreServer;
import plus.easydo.starter.file.FileResult;
import plus.easydo.starter.file.FileStoreObject;
import plus.easydo.starter.file.FileStoreUtil;
import plus.easydo.starter.file.exception.FileStoreException;
import plus.easydo.starter.file.local.LocalFileStoreTemplate;

@Component
public class LocalFileStoreService
extends CommonFileStoreServer<String, MultipartFile, InputStream, LocalFileStoreTemplate> {
    @Override
    public R<FileResult<String>> save(FileStoreObject<String, MultipartFile> fileStoreObject) {
        R<FileResult<String>> result = super.save(fileStoreObject);
        ((LocalFileStoreTemplate)this.template).save(this.groupName, this.filePath, this.fileName, (MultipartFile)this.file);
        FileResult resultFile = (FileResult)result.getData();
        resultFile.setIndex(FileStoreUtil.endWithSlash(this.groupName) + FileStoreUtil.endWithSlash(this.filePath) + this.fileName);
        resultFile.setUrl(FileStoreUtil.endWithSlash(this.groupName) + FileStoreUtil.endWithSlash(this.filePath) + this.fileName);
        result.setData((Object)resultFile);
        return result;
    }

    @Override
    public InputStream getFile(String groupName, String fileIndex) {
        if (StrUtil.isBlank((CharSequence)fileIndex)) {
            throw new FileStoreException("fileId is empty");
        }
        return ((LocalFileStoreTemplate)this.template).getFile(groupName, fileIndex);
    }

    @Override
    public Boolean remove(String groupName, String fileIndex) {
        return ((LocalFileStoreTemplate)this.template).remove(groupName, fileIndex);
    }

    @Override
    public void copy(String groupName, String index, String targetGroupName, String targetIndex) {
        ((LocalFileStoreTemplate)this.template).copy(groupName, index, targetGroupName, targetIndex);
    }

    @Override
    public void move(String groupName, String index, String targetGroupName, String targetIndex) {
        ((LocalFileStoreTemplate)this.template).move(groupName, index, targetGroupName, targetIndex);
    }

    @Override
    public String buildFileName(MultipartFile file, String fileName) {
        String prefix = RandomUtil.randomNumbers((int)10) + "-local-";
        if (StrUtil.isNotBlank((CharSequence)fileName) && !"null".equals(fileName)) {
            return prefix + fileName;
        }
        String originalFilename = file.getOriginalFilename();
        if (StrUtil.isNotBlank((CharSequence)originalFilename)) {
            return prefix + originalFilename;
        }
        return prefix;
    }

    @Override
    public String buildGroupName(String groupName) {
        if (StrUtil.isBlank((CharSequence)groupName) || "null".equals(groupName)) {
            groupName = ((LocalFileStoreTemplate)this.template).getDefaultGroupName();
        }
        return groupName;
    }

    @Override
    public BigDecimal getFileKbSize(MultipartFile file) {
        float size = Float.parseFloat(String.valueOf(file.getSize())) / 1024.0f;
        return BigDecimal.valueOf(size).setScale(2, RoundingMode.HALF_UP);
    }
}

