/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file.minio;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import plus.easydo.core.result.R;
import plus.easydo.starter.file.CommonFileStoreServer;
import plus.easydo.starter.file.FileResult;
import plus.easydo.starter.file.FileStoreObject;
import plus.easydo.starter.file.FileStoreUtil;
import plus.easydo.starter.file.exception.FileStoreException;
import plus.easydo.starter.file.minio.MinioTemplate;

@Service
public class MinioFileStoreServer
extends CommonFileStoreServer<String, MultipartFile, InputStream, MinioTemplate> {
    @Override
    public R<FileResult<String>> save(FileStoreObject<String, MultipartFile> fileStoreObject) {
        try {
            R<FileResult<String>> result = super.save(fileStoreObject);
            InputStream in = ((MultipartFile)this.file).getInputStream();
            String contentType = ((MultipartFile)this.file).getContentType();
            if (!((MinioTemplate)this.template).bucketExists(this.groupName)) {
                ((MinioTemplate)this.template).createBucket(this.groupName);
            }
            ((MinioTemplate)this.template).putObject(this.groupName, this.filePath + this.fileName, in, ((MultipartFile)this.file).getSize(), contentType);
            FileResult resultFile = (FileResult)result.getData();
            resultFile.setIndex(FileStoreUtil.endWithSlash(this.groupName) + FileStoreUtil.endWithSlash(this.filePath) + this.fileName);
            resultFile.setUrl(FileStoreUtil.endWithSlash(this.groupName) + FileStoreUtil.endWithSlash(this.filePath) + this.fileName);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return MinioFileStoreServer.fail();
        }
    }

    @Override
    public InputStream getFile(String groupName, String fileIndex) {
        if (StrUtil.isBlank((CharSequence)fileIndex)) {
            throw new FileStoreException("fileIndex is empty");
        }
        try {
            return ((MinioTemplate)this.template).getObject(this.buildGroupName(groupName), fileIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileStoreException("File does not exist");
        }
    }

    @Override
    public Boolean remove(String groupName, String fileIndex) {
        if (StrUtil.isBlank((CharSequence)fileIndex)) {
            throw new FileStoreException("fileIndex is empty");
        }
        if (StrUtil.isBlank((CharSequence)groupName)) {
            try {
                ((MinioTemplate)this.template).removeObject(((MinioTemplate)this.template).getDefaultBucket(), fileIndex);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            ((MinioTemplate)this.template).removeObject(groupName, fileIndex);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void copy(String groupName, String index, String targetGroupName, String targetIndex) {
        ((MinioTemplate)this.template).copy(groupName, index, targetGroupName, targetIndex);
    }

    @Override
    public void move(String groupName, String index, String targetGroupName, String targetIndex) {
        ((MinioTemplate)this.template).move(groupName, index, targetGroupName, targetIndex);
    }

    @Override
    public void validationFile(MultipartFile multipartFile) {
        super.validationFile(multipartFile);
        if (multipartFile.getSize() == 0L) {
            throw new FileStoreException("fileId is empty");
        }
    }

    @Override
    public String buildFileName(MultipartFile file, String fileName) {
        String prefix = RandomUtil.randomNumbers((int)10) + "-minio-";
        if (StrUtil.isNotBlank((CharSequence)fileName) && !"null".equals(fileName)) {
            return prefix + fileName;
        }
        String originalFilename = file.getOriginalFilename();
        if (StrUtil.isNotBlank((CharSequence)originalFilename)) {
            return prefix + originalFilename;
        }
        return prefix;
    }

    @Override
    public String buildGroupName(String groupName) {
        if (StrUtil.isBlank((CharSequence)groupName) || "null".equals(groupName)) {
            groupName = ((MinioTemplate)this.template).getDefaultBucket();
        }
        return groupName;
    }

    @Override
    public BigDecimal getFileKbSize(MultipartFile file) {
        float size = Float.parseFloat(String.valueOf(file.getSize())) / 1024.0f;
        return BigDecimal.valueOf(size).setScale(2, RoundingMode.HALF_UP);
    }
}

