/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file.minio;

import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.Result;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import plus.easydo.starter.file.exception.FileStoreException;
import plus.easydo.starter.file.minio.MinioItem;
import plus.easydo.starter.file.minio.config.MinioProperties;

@Component
@EnableConfigurationProperties(value={MinioProperties.class})
public class MinioTemplate {
    @Autowired
    private MinioClient client;
    @Autowired
    private MinioProperties properties;

    public String getDefaultBucket() {
        return this.properties.getDefaultBucket();
    }

    public boolean bucketExists(String bucketName) {
        return this.client.bucketExists(bucketName);
    }

    public void createBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.client.makeBucket(bucketName);
        }
    }

    public List<Bucket> getAllBuckets() {
        return this.client.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.client.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst();
    }

    public void removeBucket(String bucketName) {
        this.client.removeBucket(bucketName);
    }

    public List<MinioItem> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        ArrayList<MinioItem> objectList = new ArrayList<MinioItem>();
        Iterable objectsIterator = this.client.listObjects(bucketName, prefix, recursive);
        for (Result result : objectsIterator) {
            objectList.add(new MinioItem((Item)result.get()));
        }
        return objectList;
    }

    public String getObjectURL(String bucketName, String objectName, Integer expires) {
        return this.client.presignedGetObject(bucketName, objectName, expires);
    }

    public String getObjectURL(String bucketName, String objectName) {
        return this.client.presignedGetObject(bucketName, objectName);
    }

    public InputStream getObject(String bucketName, String objectName) {
        return this.client.getObject(bucketName, objectName);
    }

    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        this.client.putObject(bucketName, objectName, stream, null, null, null, "application/octet-stream");
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) throws Exception {
        this.client.putObject(bucketName, objectName, stream, Long.valueOf(size), null, null, contextType);
    }

    public ObjectStat getObjectInfo(String bucketName, String objectName) throws Exception {
        return this.client.statObject(bucketName, objectName);
    }

    public void removeObject(String bucketName, String objectName) {
        try {
            this.client.removeObject(bucketName, objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileStoreException("\u5220\u9664\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
    }

    public void copy(String bucketName, String name, String targetBucketName, String targetName) {
        try {
            this.client.copyObject(bucketName, name, null, null, targetBucketName, targetName, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileStoreException("\u590d\u5236\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
    }

    public void move(String bucketName, String name, String targetBucketName, String targetName) {
        try {
            this.client.copyObject(bucketName, name, null, null, targetBucketName, targetName, null, null);
            this.client.removeObject(bucketName, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FileStoreException("\u79fb\u52a8\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
    }

    public MinioClient getClient() {
        return this.client;
    }

    public MinioProperties getProperties() {
        return this.properties;
    }

    public void setClient(MinioClient client) {
        this.client = client;
    }

    public void setProperties(MinioProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinioTemplate)) {
            return false;
        }
        MinioTemplate other = (MinioTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MinioClient this$client = this.getClient();
        MinioClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        MinioProperties this$properties = this.getProperties();
        MinioProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinioTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MinioClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        MinioProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "MinioTemplate(client=" + this.getClient() + ", properties=" + this.getProperties() + ")";
    }
}

