/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file.minio.config;

import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.easydo.starter.file.minio.MinioFileStoreServer;
import plus.easydo.starter.file.minio.MinioTemplate;
import plus.easydo.starter.file.minio.config.MinioProperties;

@Configuration
@EnableConfigurationProperties(value={MinioProperties.class})
public class MinioAutoConfiguration {
    @Autowired
    private MinioProperties minioProperties;

    @Bean
    public MinioClient minioClient() throws InvalidPortException, InvalidEndpointException {
        return new MinioClient(this.minioProperties.getServerAddress(), this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey());
    }

    @Bean
    public MinioTemplate minioTemplate() {
        return new MinioTemplate();
    }

    @Bean
    public MinioFileStoreServer fileStoreService() {
        return new MinioFileStoreServer();
    }
}

