package plus.easydo.starter.knife4j.config;

import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.easydo.starter.knife4j.properties.Knife4jCustomProperties;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author laoyu
 * @version 1.0
 */
@RefreshScope
@Configuration
@EnableSwagger2WebMvc
@ConditionalOnProperty(name = "knife4j.custom.basePackage")
@EnableConfigurationProperties(Knife4jCustomProperties.class)
public class SwaggerConfiguration {

    @Resource
    private Knife4jCustomProperties properties;

    /**
     * 引入Knife4j提供的扩展类
     */
    private final OpenApiExtensionResolver openApiExtensionResolver;

    @Autowired
    public SwaggerConfiguration(OpenApiExtensionResolver openApiExtensionResolver) {
        this.openApiExtensionResolver = openApiExtensionResolver;
    }

    @Bean(value = "defaultApi2")
    public Docket defaultApi2() {
        ParameterBuilder ticketPar = new ParameterBuilder();
        List<Parameter> parameters = new ArrayList<>();
        Parameter p = ticketPar.name("Authorization").description("用户令牌: Bearer XX").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        Parameter p1 = ticketPar.name("X-Real-IP").description("ip地址").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        parameters.add(p);
        parameters.add(p1);

        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                /*设置全局参数*/
                .globalOperationParameters(parameters)
                .groupName(properties.getGroupName())
                .select()
                .apis(RequestHandlerSelectors.basePackage(properties.getBasePackage()))
                .paths(PathSelectors.any())
                .build()
                //赋予插件体系
                .extensions(openApiExtensionResolver.buildExtensions(properties.getGroupName()));
    }

    private ApiInfo apiInfo() {
        Contact contact = new Contact(properties.getContact().getName(), properties.getContact().getUrl(), properties.getContact().getEmail());
        return new ApiInfoBuilder()
                .title(properties.getTitle())
                .description(properties.getDescription())
                .version(properties.getVersion())
                .contact(contact)
                .build();
    }
}