/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.mybatis.plus.result;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.List;
import plus.easydo.starter.mybatis.plus.result.MPDataResult;

public class MPResultUtil {
    private MPResultUtil() {
    }

    public static <T> MPDataResult<T> buildPageData(IPage<T> page, List<T> list) {
        Integer pageNum = (int)page.getCurrent();
        Integer pageSize = (int)page.getSize();
        Integer startRow = (int)(page.getCurrent() * page.getSize());
        Integer endRow = (int)(page.getCurrent() + page.getSize());
        Long total = page.getTotal();
        Integer pages = (int)page.getPages();
        return MPResultUtil.buildPageData(pageNum, pageSize, startRow, endRow, total, pages, list);
    }

    public static <T> MPDataResult<T> buildPageData(IPage<T> page) {
        List list = page.getRecords();
        return MPResultUtil.buildPageData(page, list);
    }

    public static <T> MPDataResult<T> buildPageData(List<T> pageList, Integer pageNum, Integer pageSize) {
        int toIndex;
        int fromIndex;
        if (CollectionUtils.isEmpty(pageList)) {
            return MPResultUtil.buildPageData(pageNum, pageSize, 0, 0, 0L, 0, pageList);
        }
        Integer count = pageList.size();
        int pageCount = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        if (!pageNum.equals(pageCount)) {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = fromIndex + pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = count;
        }
        List<T> list = pageList.subList(fromIndex, toIndex);
        return MPResultUtil.buildPageData(pageNum, pageSize, fromIndex, toIndex, (long)count, pageCount, list);
    }

    private static <T> MPDataResult<T> buildPageData(Integer pageNum, Integer pageSize, Integer startRow, Integer endRow, Long total, Integer pages, List<T> list) {
        MPDataResult<T> dataResult = new MPDataResult<T>();
        dataResult.setPageNum(pageNum);
        dataResult.setPageSize(pageSize);
        dataResult.setStartRow(startRow);
        dataResult.setEndRow(endRow);
        dataResult.setTotal(total);
        dataResult.setCount(total);
        dataResult.setPages(pages);
        dataResult.setRows(list);
        return dataResult;
    }

    public static <T> MPDataResult<T> buildPage(IPage<T> page, List<T> list) {
        Integer pageNum = (int)page.getCurrent();
        Integer pageSize = (int)page.getSize();
        Integer startRow = (int)((page.getCurrent() - 1L) * page.getSize());
        Integer endRow = (int)(page.getCurrent() * page.getSize());
        Long total = page.getTotal();
        Integer pages = (int)page.getPages();
        return MPResultUtil.buildPageData(pageNum, pageSize, startRow, endRow, total, pages, list);
    }
}

