package plus.easydo.starter.oauth.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import plus.easydo.starter.oauth.api.fallback.TokenApiFallback;

import java.security.Principal;
import java.util.Map;

/**
 * @author laoyu
 * @version 1.0
 */

@FeignClient(name = "${security.oauth2.client.oauth-server-name:oauth-server}", url = "${security.oauth2.client.oauth-server-uri:}",
        fallback = TokenApiFallback.class, configuration = {})
public interface TokenApi {

    /**
     * post方式获取token
     *
     * @param principal principal
     * @param parameters parameters
     * @return org.springframework.http.ResponseEntity
     * @author laoyu
     */
    @PostMapping(value = "/oauth/token")
    ResponseEntity<OAuth2AccessToken> postAccessToken(Principal principal, @RequestParam
            Map<String, String> parameters);

    /**
     * get方式获取token
     *
     * @param principal principal
     * @param parameters parameters
     * @return org.springframework.http.ResponseEntity
     * @author laoyu
     */
    @GetMapping(value = "/oauth/token")
    ResponseEntity<OAuth2AccessToken> getAccessToken(Principal principal, @RequestParam
            Map<String, String> parameters);

    /**
     * 校验token
     *
     * @param value value
     * @return java.util.Map
     * @author laoyu
     */
    @RequestMapping(value = "/oauth/check_token")
    Map<String, Object> checkToken(@RequestParam("token") String value);

}
