/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.client.service;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.util.StringUtils;
import plus.easydo.starter.oauth.api.TokenApi;
import plus.easydo.starter.oauth.core.config.SecurityBeanConfig;

public class CustomizeClientServer {
    Logger log = LoggerFactory.getLogger(CustomizeClientServer.class);
    private boolean isOauthServer;
    private String token = "";
    private OAuth2AccessToken oAuth2AccessToken;
    private final OAuth2ProtectedResourceDetails resource;
    private final OAuth2RestTemplate oAuth2RestTemplate;
    @Autowired(required=false)
    TokenApi tokenApi;
    @Qualifier(value="serverBeanConfig")
    @Autowired(required=false)
    private SecurityBeanConfig securityBeanConfig;

    public CustomizeClientServer(OAuth2ProtectedResourceDetails clientCredentialsResourceDetails) {
        this.log.info("\u521d\u59cb\u5316CustomizeClientServer");
        this.resource = clientCredentialsResourceDetails;
        this.oAuth2RestTemplate = new OAuth2RestTemplate(clientCredentialsResourceDetails);
    }

    public OAuth2AccessToken getAccessToken() throws UserRedirectRequiredException {
        if (StringUtils.isEmpty((Object)this.token)) {
            if (this.isOauthServer()) {
                return this.localServerGetAccessToken();
            }
            return this.remoteGetAccessToken();
        }
        this.checkToken(this.token);
        return this.oAuth2AccessToken;
    }

    private boolean isOauthServer() {
        this.isOauthServer = this.securityBeanConfig != null;
        return this.isOauthServer;
    }

    public OAuth2AccessToken localServerGetAccessToken() {
        AuthorizationServerTokenServices tokenService = this.securityBeanConfig.getAuthorizationServerTokenServices();
        ClientDetails client = this.securityBeanConfig.getClientDetailsService().loadClientByClientId(this.resource.getClientId());
        Collection authorities = client.getAuthorities();
        Set resourceIds = client.getResourceIds();
        Set scope = client.getScope();
        OAuth2Request request = new OAuth2Request(null, this.resource.getClientId(), authorities, true, scope, resourceIds, null, null, null);
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication(request, null);
        OAuth2AccessToken accessToken = tokenService.getAccessToken(oAuth2Authentication);
        if (accessToken == null) {
            accessToken = tokenService.createAccessToken(oAuth2Authentication);
        }
        this.setToken(accessToken);
        this.log.info("localServerGetAccessToken()===> {}", (Object)this.token);
        return accessToken;
    }

    private void setToken(OAuth2AccessToken accessToken) {
        this.oAuth2AccessToken = accessToken;
        this.token = accessToken.getValue();
    }

    public void checkToken(String token) {
        if (this.isOauthServer) {
            DefaultTokenServices tokenServices;
            OAuth2AccessToken accToken;
            AuthorizationServerTokenServices tokenService = this.securityBeanConfig.getAuthorizationServerTokenServices();
            if (tokenService instanceof DefaultTokenServices && ((accToken = (tokenServices = (DefaultTokenServices)tokenService).readAccessToken(token)) == null || accToken.isExpired())) {
                this.log.error("checkToken()=>\u6821\u9a8c\u4ee4\u724c\u5931\u8d25\uff1a{},{}", (Object)token, (Object)"\u8c03\u7528\u672c\u5730\u670d\u52a1\u91cd\u65b0\u83b7\u53d6token");
                this.localServerGetAccessToken();
            }
        } else {
            if (Objects.nonNull(this.tokenApi)) {
                Map result = this.tokenApi.checkToken(this.token);
                this.log.info("tokenApi.checkToken(): {}", (Object)result);
                Object clientId = result.get("client_id");
                if (Objects.isNull(clientId)) {
                    this.remoteGetAccessToken();
                }
            }
            if (this.oAuth2AccessToken.isExpired()) {
                this.oAuth2RestTemplate.getOAuth2ClientContext().setAccessToken(null);
                this.remoteGetAccessToken();
            }
        }
    }

    public OAuth2AccessToken remoteGetAccessToken() {
        OAuth2AccessToken accessToken;
        if (Objects.nonNull(this.tokenApi) && Objects.nonNull(accessToken = this.feignClientGetAccessToken())) {
            this.setToken(accessToken);
            return accessToken;
        }
        accessToken = this.oAuth2RestTemplate.getAccessToken();
        this.setToken(accessToken);
        this.log.info("remoteGetAccessToken()===> {}", (Object)this.token);
        return accessToken;
    }

    public OAuth2AccessToken feignClientGetAccessToken() {
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("grant_type", this.resource.getGrantType());
        param.put("client_id", this.resource.getClientId());
        param.put("client_secret", this.resource.getClientSecret());
        List list = Collections.emptyList();
        UsernamePasswordAuthenticationToken principal = new UsernamePasswordAuthenticationToken((Object)new User(this.resource.getClientId(), "", list), null);
        ResponseEntity result = this.tokenApi.getAccessToken((Principal)principal, param);
        this.log.info("feignClientGetAccessToken()===> {}", (Object)result);
        return (OAuth2AccessToken)result.getBody();
    }
}

