package plus.easydo.starter.oauth.core.model;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;

import java.io.Serializable;
import java.util.Collection;

/**
 * 自定义 UsernamePasswordAuthenticationToken
 * @author yuzhanfeng
 */
public class CustomizeUsernamePasswordAuthenticationToken extends UsernamePasswordAuthenticationToken implements Authentication, CredentialsContainer {

    private static final long serialVersionUID = 1905122041950251207L;

    private Collection<? extends Serializable> permissions;

    public CustomizeUsernamePasswordAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public CustomizeUsernamePasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    public Collection<? extends Serializable> getPermissions() {
        return permissions;
    }

    public void setPermissions(Collection<? extends Serializable> permissions) {
        this.permissions = permissions;
    }

}
