/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.controller;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;

@Controller
public class CustomizeOauthController {
    @Autowired
    Oauth2ServerProperties oAuth2Properties;

    @GetMapping(value={"${oauth2.customize.login-path:/login}"})
    public String loginPage(Model model) {
        model.addAttribute(this.oAuth2Properties.getLoginSubmitUrlKey(), (Object)"/auth/authorize");
        return this.oAuth2Properties.getLoginHtml();
    }

    @RequestMapping(value={"${oauth2.customize.confirm-access-path:/custom/confirm_access}"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        ModelAndView view = new ModelAndView();
        view.setViewName(this.oAuth2Properties.getConfirmAccessHtmlPrefix());
        view.addObject("clientId", (Object)authorizationRequest.getClientId());
        view.addObject("scopes", (Object)authorizationRequest.getScope());
        return view;
    }
}

