/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.exception;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.UnsupportedGrantTypeException;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import plus.easydo.core.result.DataResult;
import plus.easydo.starter.oauth.core.exception.CustomizeOAuth2Exception;

public class CustomizeOauth2WebResponseExceptionTranslator
implements WebResponseExceptionTranslator<OAuth2Exception> {
    private static final String UNSUPPORTED_GRANT_TYPE = "Unsupported grant type";
    private static final String BAD_CREDENTIALS = "Bad credentials";
    private final ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

    public ResponseEntity<OAuth2Exception> translate(Exception e) {
        Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)e);
        Exception ase = (Exception)this.throwableAnalyzer.getFirstThrowableOfType(Exception.class, causeChain);
        if (ase instanceof InternalAuthenticationServiceException) {
            return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u5185\u90e8\u8ba4\u8bc1\u670d\u52a1\u5f02\u5e38:" + e.getMessage()));
        }
        if (ase instanceof UnsupportedGrantTypeException) {
            return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u4e0d\u652f\u6301\u7684\u9a8c\u8bc1\u65b9\u5f0f", (Throwable)ase));
        }
        if (ase instanceof InvalidGrantException) {
            String msg = ase.getMessage();
            if (msg.contains(UNSUPPORTED_GRANT_TYPE)) {
                return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u4e0d\u652f\u6301\u7684\u9a8c\u8bc1\u65b9\u5f0f", (Throwable)ase));
            }
            if (msg.contains(BAD_CREDENTIALS)) {
                return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef", (Throwable)ase));
            }
            return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u8bf7\u6c42\u7c7b\u578b\u6216\u53c2\u6570\u9519\u8bef:" + e.getMessage(), (Throwable)ase));
        }
        if (ase instanceof AccessDeniedException) {
            return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u62d2\u7edd\u88ab\u8bbf\u95ee:" + e.getMessage(), (Throwable)ase));
        }
        if (ase instanceof AuthenticationException) {
            return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception("\u9a8c\u8bc1\u5f02\u5e38:" + e.getMessage()));
        }
        if (ase instanceof OAuth2Exception) {
            return this.handleOauth2Exception((OAuth2Exception)ase);
        }
        if (ase instanceof HttpRequestMethodNotSupportedException) {
            return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception(ase.getMessage(), (Throwable)ase));
        }
        return this.handleOauth2Exception((OAuth2Exception)new CustomizeOAuth2Exception(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)ase));
    }

    private ResponseEntity<OAuth2Exception> handleOauth2Exception(OAuth2Exception e) {
        int status = e.getHttpErrorCode();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json;charset=UTF-8");
        if (status == HttpStatus.UNAUTHORIZED.value() || e instanceof InsufficientScopeException) {
            headers.set("WWW-Authenticate", String.format("%s %s", "Bearer", e.getSummary()));
        }
        return new ResponseEntity((Object)DataResult.fail((int)status, (String)e.getMessage()), (MultiValueMap)headers, HttpStatus.valueOf((int)status));
    }
}

