/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.server.service;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import plus.easydo.starter.oauth.core.model.CustomizeUserDetails;
import plus.easydo.starter.oauth.server.properties.Oauth2ServerProperties;

public class CustomizeDefaultUserAuthenticationConverter
extends DefaultUserAuthenticationConverter
implements UserAuthenticationConverter {
    private final Oauth2ServerProperties oauth2ServerProperties;

    public CustomizeDefaultUserAuthenticationConverter(Oauth2ServerProperties oauth2ServerProperties) {
        this.oauth2ServerProperties = oauth2ServerProperties;
    }

    public Map<String, ?> convertUserAuthentication(Authentication authentication) {
        Object principal;
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("user_name", authentication.getName());
        if (authentication.getAuthorities() != null && !authentication.getAuthorities().isEmpty()) {
            response.put("authorities", AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities()));
        }
        if (this.oauth2ServerProperties.isTokenInfoUser() && (principal = authentication.getPrincipal()) instanceof CustomizeUserDetails) {
            CustomizeUserDetails myUserDetails = (CustomizeUserDetails)principal;
            response.put("user", myUserDetails.getUser());
            response.put("permissions", myUserDetails.getPermissions());
        }
        if (this.oauth2ServerProperties.isTokenInfoAll()) {
            response.put("ALL", authentication);
        }
        return response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomizeDefaultUserAuthenticationConverter that = (CustomizeDefaultUserAuthenticationConverter)((Object)o);
        return Objects.equals(this.oauth2ServerProperties, that.oauth2ServerProperties);
    }

    public int hashCode() {
        return Objects.hash(this.oauth2ServerProperties);
    }
}

