package plus.easydo.starter.plugins.gen.configure;

import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import plus.easydo.starter.plugins.gen.controller.GenController;
import plus.easydo.starter.plugins.gen.service.IGenTableColumnService;
import plus.easydo.starter.plugins.gen.service.IGenTableService;
import plus.easydo.starter.plugins.gen.service.impl.GenTableColumnServiceImpl;
import plus.easydo.starter.plugins.gen.service.impl.GenTableServiceImpl;

/**
 * @author laoyu
 * @version 1.0
 */
@Configuration
@EnableConfigurationProperties(GenConfig.class)
@Import({GenController.class})
public class GenAutoConfigure {

    @Bean
    public MapperScannerConfigurer mapperScannerConfigurer() {
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setBasePackage("plus.easydo.starter.plugins.gen.mapper");
        return mapperScannerConfigurer;
    }

    @Bean
    public IGenTableService iGenTableService(){
        return new GenTableServiceImpl();
    }

    @Bean
    public IGenTableColumnService iGenTableColumnService(){
        return new GenTableColumnServiceImpl();
    }




}
