package plus.easydo.starter.plugins.gen.controller;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.easydo.starter.plugins.gen.entity.GenTable;
import plus.easydo.starter.plugins.gen.entity.GenTableColumn;
import plus.easydo.starter.plugins.gen.service.IGenTableColumnService;
import plus.easydo.starter.plugins.gen.service.IGenTableService;
import plus.easydo.core.result.DataResult;
import plus.easydo.starter.mybatis.base.MybatisBaseController;
import plus.easydo.utils.text.Convert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 代码生成
 *
 * @author laoyu
 */
@RequestMapping("/gen")
@RestController
public class GenController extends MybatisBaseController {
    @Autowired
    private IGenTableService genTableService;

    @Autowired
    private IGenTableColumnService genTableColumnService;

    /**
     * 查询代码生成列表
     *
     * @param genTable genTable
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping("/list")
    public DataResult<Object> genList(GenTable genTable) {
        startPage();
        List<GenTable> list = genTableService.selectGenTableList(genTable);
        return resultTable(list);
    }

    /**
     * 修改代码生成业务
     *
     * @param talbleId talbleId
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping(value = "/{talbleId}")
    public DataResult<Object> getInfo(@PathVariable Long talbleId) {
        GenTable table = genTableService.selectGenTableById(talbleId);
        List<GenTable> tables = genTableService.selectGenTableAll();
        List<GenTableColumn> list = genTableColumnService.selectGenTableColumnListByTableId(talbleId);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("info", table);
        map.put("rows", list);
        map.put("tables", tables);
        return ok(map);
    }

    /**
     * 查询数据库列表
     *
     * @param genTable genTable
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping("/db/list")
    public DataResult<Object> dataList(GenTable genTable) {
        startPage();
        List<GenTable> list = genTableService.selectDbTableList(genTable);
        return resultTable(list);
    }

    /**
     * 查询数据表字段列表
     *
     * @param tableId tableId
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping(value = "/column/{talbleId}")
    public DataResult<Object> columnList(Long tableId) {
        List<GenTableColumn> list = genTableColumnService.selectGenTableColumnListByTableId(tableId);
        return resultTable(list);
    }

    /**
     * 导入表结构（保存）
     *
     * @param tables tables
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @PostMapping("/importTable")
    public DataResult<Object> importTableSave(String tables) {
        String[] tableNames = Convert.toStrArray(tables);
        // 查询表信息
        List<GenTable> tableList = genTableService.selectDbTableListByNames(tableNames);
        genTableService.importGenTable(tableList);
        return ok();
    }

    /**
     * 修改保存代码生成业务
     *
     * @param genTable genTable
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @PutMapping
    public DataResult<Object> editSave(@Validated @RequestBody GenTable genTable) {
        genTableService.validateEdit(genTable);
        genTableService.updateGenTable(genTable);
        return ok();
    }

    /**
     * 删除代码生成
     *
     * @param tableIds tableIds
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @DeleteMapping("/{tableIds}")
    public DataResult<Object> remove(@PathVariable Long[] tableIds) {
        genTableService.deleteGenTableByIds(tableIds);
        return ok();
    }

    /**
     * 预览代码
     *
     * @param tableId tableId
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping("/preview/{tableId}")
    public DataResult<Object> preview(@PathVariable("tableId") Long tableId) {
        Map<String, String> dataMap = genTableService.previewCode(tableId);
        return ok(dataMap);
    }

    /**
     * 生成代码（下载方式）
     *
     * @param response response
     * @param tableName tableName
     * @throws  IOException IOException
     * @author laoyu
     */
    @GetMapping("/download/{tableName}")
    public void download(HttpServletResponse response, @PathVariable("tableName") String tableName) throws IOException {
        byte[] data = genTableService.downloadCode(tableName);
        genCode(response, data, tableName);
    }

    /**
     * 生成代码（自定义路径）
     *
     * @param tableName tableName
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping("/genCode/{tableName}")
    public DataResult<Object> genCode(@PathVariable("tableName") String tableName) {
        genTableService.generatorCode(tableName);
        return ok();
    }

    /**
     * 同步数据库
     *
     * @param tableName tableName
     * @return plus.easydo.core.result.DataResult
     * @author laoyu
     */
    @GetMapping("/synchDb/{tableName}")
    public DataResult<Object> synchDb(@PathVariable("tableName") String tableName) {
        genTableService.synchDb(tableName);
        return ok();
    }

    /**
     * 批量生成代码
     *
     * @param response response
     * @param tables tables
     * @throws IOException IOException
     * @author laoyu
     */
    @GetMapping("/batchGenCode")
    public void batchGenCode(HttpServletResponse response, String tables) throws IOException {
        String[] tableNames = Convert.toStrArray(tables);
        byte[] data = genTableService.downloadCode(tableNames);
        genCode(response, data, tables);
    }

    /**
     * 生成zip文件
     *
     * @param response response
     * @param data data
     * @param fileName fileName
     * @throws IOException IOException
     * @author laoyu
     */
    private void genCode(HttpServletResponse response, byte[] data,String fileName) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".zip");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write(data, response.getOutputStream());
    }
}
