package plus.easydo.starter.plugins.gen.configure;

import org.apache.velocity.runtime.resource.loader.DataSourceResourceLoader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.easydo.jdbc.annotation.EnableJdbcDynamicDataSource;
import plus.easydo.jdbc.configuration.DynamicDataSourceAutoConfiguration;
import plus.easydo.starter.plugins.gen.controller.GenController;
import plus.easydo.starter.plugins.gen.controller.TemplateManagementController;
import plus.easydo.starter.plugins.gen.service.IGenTableColumnService;
import plus.easydo.starter.plugins.gen.service.IGenTableService;
import plus.easydo.starter.plugins.gen.service.TemplateManagementService;
import plus.easydo.starter.plugins.gen.service.impl.GenTableColumnServiceImpl;
import plus.easydo.starter.plugins.gen.service.impl.GenTableServiceImpl;
import plus.easydo.starter.plugins.gen.service.impl.TemplateManagementServiceImpl;
import plus.easydo.starter.plugins.gen.util.VelocityInitializer;

import javax.sql.DataSource;

/**
 * @author laoyu
 * @version 1.0
 */
@Configuration
@EnableConfigurationProperties(GenConfig.class)
@ConditionalOnBean(DynamicDataSourceAutoConfiguration.class)
@EnableJdbcDynamicDataSource
public class GenAutoConfigure {

    @Bean
    public IGenTableService iGenTableService() {
        return new GenTableServiceImpl();
    }

    @Bean
    public IGenTableColumnService iGenTableColumnService() {
        return new GenTableColumnServiceImpl();
    }

    /**
     * 模板管理业务层
     *
     * @return plus.easydo.jdbc.manager.service.TemplateManagementService
     * @author laoyu
     */
    @Bean
    public TemplateManagementService templateManagementService() {
        return new TemplateManagementServiceImpl();
    }


    /**
     * 实例化 Velocity加载类
     * 将数据源注入到Velocity的DataSourceResourceLoader以支持数据源读取模板
     * @param dataSource dataSource
     * @return plus.easydo.starter.plugins.gen.util.VelocityInitializer
     * @author laoyu
     */
    @Bean
    public VelocityInitializer velocityInitializer(DataSource dataSource) {
        DataSourceResourceLoader dataSourceResourceLoader = new DataSourceResourceLoader();
        dataSourceResourceLoader.setDataSource(dataSource);
        return new VelocityInitializer(dataSourceResourceLoader);
    }


    @Bean
    @ConditionalOnBean({IGenTableService.class,IGenTableColumnService.class})
    public GenController genController(){
        return new GenController();
    }

    @Bean
    @ConditionalOnBean(TemplateManagementService.class)
    public TemplateManagementController templateManagementController(){
        return new TemplateManagementController();
    }



}
