package plus.easydo.starter.plugins.gen.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.easydo.core.result.R;
import plus.easydo.core.vaild.Insert;
import plus.easydo.core.vaild.Update;
import plus.easydo.starter.mybatis.plus.base.MPBaseController;
import plus.easydo.starter.mybatis.plus.result.MPDataResult;
import plus.easydo.starter.plugins.gen.dto.TemplateManagementDto;
import plus.easydo.starter.plugins.gen.qo.TemplateManagementQo;
import plus.easydo.starter.plugins.gen.service.TemplateManagementService;
import plus.easydo.starter.plugins.gen.vo.TemplateManagementVo;

import java.util.List;

/**
 * 模板管理Controller
 * 
 * @author gebilaoyu
 */
@RestController
@RequestMapping("/template")
public class TemplateManagementController extends MPBaseController {

    @Autowired
    private TemplateManagementService templateManagementService;

    /**
     * 分页条件查询模板管理列表
     *
     * @param qo qo
     * @return plus.easydo.starter.mybatis.plus.result.MPDataResult
     * @author laoyu
     */
    @PostMapping("/page")
    public MPDataResult<TemplateManagementVo> page(@RequestBody TemplateManagementQo qo) {
        IPage<TemplateManagementVo> page = templateManagementService.page(qo);
        return ok(page);
    }

    /**
     * 获取所有模板管理列表
     *
     * @param qo qo
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
    @PostMapping("/list")
    public R<List<TemplateManagementVo>> list(@RequestBody TemplateManagementQo qo) {
        return ok(templateManagementService.list(qo));
    }


    /**
     * 获取模板管理详细信息
     *
     * @param id id
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
    @GetMapping(value = "/{id}")
    public R<Object> getInfo(@PathVariable("id") Long id) {
        return ok(templateManagementService.selectById(id));
    }

    /**
     * 新增模板管理
     *
     * @param dto dto
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
    @PostMapping
    public R<Object> add(@RequestBody @Validated(Insert.class) TemplateManagementDto dto) {
        return opResult(templateManagementService.insert(dto));
    }

    /**
     * 修改模板管理
     *
     * @param dto dto
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
    @PutMapping
    public R<Object> edit(@RequestBody @Validated(Update.class) TemplateManagementDto dto) {
        return opResult(templateManagementService.update(dto));
    }

    /**
     * 删除模板管理
     *
     * @param ids ids
     * @return plus.easydo.core.result.R
     * @author laoyu
     */
	@DeleteMapping("/{ids}")
    public R<Object> remove(@PathVariable Long[] ids) {
        return opResult(templateManagementService.deleteByIds(ids));
    }
}
