package plus.easydo.starter.plugins.gen.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 模板管理数据传输对象
 * 
 * @author gebilaoyu
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = false)
public class TemplateManagementDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 自增主键 */
    private Long id;

    /** 模板名称 */
    private String templateName;

    /** 代码 */
    private String templateCode;

    /** 包路径 */
    private String packagePath;

    /** 文件名 */
    private String fileName;

    /** 文件路径 */
    private String filePath;

    /** 备注 */
    private String remark;

}
