package plus.easydo.starter.plugins.gen.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import plus.easydo.starter.mybatis.plus.entity.MPBaseEntity;

/**
 * 模板管理数据库映射对象
 * 
 * @author gebilaoyu
 */
@Data
@ToString
@SuperBuilder
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("template_management")
public class TemplateManagement extends MPBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 自增主键 */
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 模板名称 */
    private String templateName;

    /** 代码 */
    private String templateCode;

    /** 包路径 */
    private String packagePath;

    /** 文件名 */
    private String fileName;

    /** 文件路径 */
    private String filePath;

    /** 删除标志 */
    private Integer delFlag;

}
