package plus.easydo.starter.plugins.gen.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import plus.easydo.starter.plugins.gen.entity.TemplateManagement;
import plus.easydo.starter.plugins.gen.qo.TemplateManagementQo;

/**
 * 模板管理Mapper接口
 * 
 * @author gebilaoyu
 */
@Mapper
public interface TemplateManagementMapper extends BaseMapper<TemplateManagement> {
    /**
     * 查询模板管理
     *
     * @param id 模板管理ID
     * @return 模板管理
     */
    TemplateManagement selectTemplateManagementById(Long id);

    /**
     * 分页条件查询模板管理列表
     *
     * @param page 分页数据
     * @param qo 查询条件封装
     * @return 模板管理集合
     */
    IPage<TemplateManagement> selectTemplateManagementList(IPage<TemplateManagement> page, @Param("qo") TemplateManagementQo qo);

    /**
     * 新增模板管理
     * 
     * @param templateManagement 模板管理
     * @return 结果
     */
    int insertTemplateManagement(TemplateManagement templateManagement);

    /**
     * 修改模板管理
     * 
     * @param templateManagement 模板管理
     * @return 结果
     */
    int updateTemplateManagement(TemplateManagement templateManagement);

    /**
     * 删除模板管理
     * 
     * @param id 模板管理ID
     * @return 结果
     */
    int deleteTemplateManagementById(Long id);

    /**
     * 批量删除模板管理
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteTemplateManagementByIds(Long[] ids);
}
