package plus.easydo.starter.plugins.gen.qo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import plus.easydo.starter.mybatis.plus.qo.MpBaseQo;

/**
 * 模板管理查询对象
 * 
 * @author gebilaoyu
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class TemplateManagementQo extends MpBaseQo {

    /** 自增主键 */
    private Long id;

    /** 模板名称 */
    private String templateName;

    /** 代码 */
    private String templateCode;

    /** 包路径 */
    private String packagePath;

    /** 文件名 */
    private String fileName;

    /** 文件路径 */
    private String filePath;

    /** 删除标志 */
    private Integer delFlag;

}
