package plus.easydo.starter.plugins.gen.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import plus.easydo.starter.plugins.gen.dto.TemplateManagementDto;
import plus.easydo.starter.plugins.gen.entity.TemplateManagement;
import plus.easydo.starter.plugins.gen.mapper.TemplateManagementMapper;
import plus.easydo.starter.plugins.gen.qo.TemplateManagementQo;
import plus.easydo.starter.plugins.gen.service.TemplateManagementService;
import plus.easydo.starter.plugins.gen.vo.TemplateManagementVo;
import plus.easydo.utils.ResultConvertUtil;

import java.util.Arrays;
import java.util.List;


/**
 * 模板管理Service层
 * 
 * @author gebilaoyu
 */
@Service
public class TemplateManagementServiceImpl extends ServiceImpl<TemplateManagementMapper, TemplateManagement> implements TemplateManagementService {



    /**
     * 查询模板管理
     * 
     * @param id 模板管理ID
     * @return 模板管理
     */
    @Override
    public TemplateManagementVo selectById(Long id) {
        TemplateManagement templateManagement = baseMapper.selectById(id);
        return ResultConvertUtil.convertVo(templateManagement,TemplateManagementVo::new);
    }

    /**
     * 分页条件查询模板管理列表
     * 
     * @param qo 查询条件封装
     * @return 模板管理
     */
    @Override
    public IPage<TemplateManagementVo> page(TemplateManagementQo qo) {
        IPage<TemplateManagement> page = qo.startPage();
        IPage<TemplateManagement> iPage = baseMapper.selectTemplateManagementList(page, qo);
        List<TemplateManagementVo> voList = ResultConvertUtil.copyList(iPage.getRecords(), TemplateManagementVo::new);
        IPage<TemplateManagementVo> voPage = new Page<>();
        BeanUtils.copyProperties(iPage,voPage);
        voPage.setRecords(voList);
        return voPage;
    }

    /**
     * 获取所有模板管理列表
     *
     * @param qo 查询条件封装
     * @return 模板管理
     */
    @Override
    public List<TemplateManagementVo> list(TemplateManagementQo qo) {
        List<TemplateManagement> list = baseMapper.selectList(Wrappers.query());
        return ResultConvertUtil.copyList(list,TemplateManagementVo::new);

    }

    /**
     * 新增模板管理
     * 
     * @param dto 数据传输对象
     * @return 结果
     */
    @Override
    public int insert(TemplateManagementDto dto) {
        TemplateManagement templateManagement = TemplateManagement.builder().build();
        BeanUtils.copyProperties(dto, templateManagement);
        templateManagement.buildTimeAll();
                return baseMapper.insert(templateManagement);
    }

    /**
     * 修改模板管理
     * 
     * @param dto 数据传输对象
     * @return 结果
     */
    @Override
    public int update(TemplateManagementDto dto) {
        TemplateManagement templateManagement = TemplateManagement.builder().build();
        BeanUtils.copyProperties(dto, templateManagement);
        templateManagement.buildUpdateTime();
        return baseMapper.updateById(templateManagement);
    }

    /**
     * 批量删除模板管理
     * 
     * @param ids 需要删除的模板管理ID
     * @return 结果
     */
    @Override
    public Boolean deleteByIds(Long[] ids) {
        return removeByIds(Arrays.asList(ids));
    }

    /**
     * 删除模板管理信息
     * 
     * @param id 模板管理ID
     * @return 结果
     */
    @Override
    public Boolean deleteById(Long id) {
        return removeById(id);
    }

    @Override
    public List<TemplateManagementVo> selectByIds(String[] ids) {
        List<TemplateManagement> list = baseMapper.selectBatchIds(Arrays.asList(ids));
       return ResultConvertUtil.copyList(list,TemplateManagementVo::new);
    }

}
