/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.plugins.gen.configure;

import javax.sql.DataSource;
import org.apache.velocity.runtime.resource.loader.DataSourceResourceLoader;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.easydo.jdbc.annotation.EnableJdbcDynamicDataSource;
import plus.easydo.jdbc.configuration.DynamicDataSourceAutoConfiguration;
import plus.easydo.starter.plugins.gen.configure.GenConfig;
import plus.easydo.starter.plugins.gen.controller.GenController;
import plus.easydo.starter.plugins.gen.controller.TemplateManagementController;
import plus.easydo.starter.plugins.gen.service.IGenTableColumnService;
import plus.easydo.starter.plugins.gen.service.IGenTableService;
import plus.easydo.starter.plugins.gen.service.TemplateManagementService;
import plus.easydo.starter.plugins.gen.service.impl.GenTableColumnServiceImpl;
import plus.easydo.starter.plugins.gen.service.impl.GenTableServiceImpl;
import plus.easydo.starter.plugins.gen.service.impl.TemplateManagementServiceImpl;
import plus.easydo.starter.plugins.gen.util.VelocityInitializer;

@Configuration
@EnableConfigurationProperties(value={GenConfig.class})
@ConditionalOnBean(value={DynamicDataSourceAutoConfiguration.class})
@EnableJdbcDynamicDataSource
public class GenAutoConfigure {
    @Bean
    public IGenTableService iGenTableService() {
        return new GenTableServiceImpl();
    }

    @Bean
    public IGenTableColumnService iGenTableColumnService() {
        return new GenTableColumnServiceImpl();
    }

    @Bean
    public TemplateManagementService templateManagementService() {
        return new TemplateManagementServiceImpl();
    }

    @Bean
    public VelocityInitializer velocityInitializer(DataSource dataSource) {
        DataSourceResourceLoader dataSourceResourceLoader = new DataSourceResourceLoader();
        dataSourceResourceLoader.setDataSource(dataSource);
        return new VelocityInitializer(dataSourceResourceLoader);
    }

    @Bean
    @ConditionalOnBean(value={IGenTableService.class, IGenTableColumnService.class})
    public GenController genController() {
        return new GenController();
    }

    @Bean
    @ConditionalOnBean(value={TemplateManagementService.class})
    public TemplateManagementController templateManagementController() {
        return new TemplateManagementController();
    }
}

