/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.plugins.gen.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import plus.easydo.core.result.DataResult;
import plus.easydo.core.result.R;
import plus.easydo.starter.mybatis.plus.base.MPBaseController;
import plus.easydo.starter.plugins.gen.entity.GenTable;
import plus.easydo.starter.plugins.gen.entity.GenTableColumn;
import plus.easydo.starter.plugins.gen.service.IGenTableColumnService;
import plus.easydo.starter.plugins.gen.service.IGenTableService;
import plus.easydo.utils.text.Convert;

@RequestMapping(value={"/gen"})
@RestController
public class GenController
extends MPBaseController {
    @Autowired
    private IGenTableService genTableService;
    @Autowired
    private IGenTableColumnService genTableColumnService;

    @GetMapping(value={"/list"})
    public R<Object> genList(GenTable genTable) {
        List<GenTable> list = this.genTableService.selectGenTableList(genTable);
        return GenController.ok(list);
    }

    @GetMapping(value={"/{tableId}"})
    public DataResult<Object> getInfo(@PathVariable Long tableId) {
        GenTable table = this.genTableService.selectGenTableById(tableId);
        List<GenTable> tables = this.genTableService.selectGenTableAll();
        List<GenTableColumn> list = this.genTableColumnService.selectGenTableColumnListByTableId(tableId);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("info", (Object)table);
        map.put("rows", list);
        map.put("tables", tables);
        return GenController.ok(map);
    }

    @GetMapping(value={"/db/list"})
    public DataResult<Object> dataList(GenTable genTable) {
        List<GenTable> list = this.genTableService.selectDbTableList(genTable);
        return GenController.ok(list);
    }

    @GetMapping(value={"/column/{talbleId}"})
    public DataResult<Object> columnList(Long tableId) {
        List<GenTableColumn> list = this.genTableColumnService.selectGenTableColumnListByTableId(tableId);
        return GenController.ok(list);
    }

    @PostMapping(value={"/importTable"})
    public DataResult<Object> importTableSave(String tables, String dataSourceId) {
        String[] tableNames = Convert.toStrArray((String)tables);
        List<GenTable> tableList = this.genTableService.selectDbTableListByNames(dataSourceId, tableNames);
        this.genTableService.importGenTable(dataSourceId, tableList);
        return GenController.ok();
    }

    @PutMapping
    public DataResult<Object> editSave(@Validated @RequestBody GenTable genTable) {
        this.genTableService.validateEdit(genTable);
        this.genTableService.updateGenTable(genTable);
        return GenController.ok();
    }

    @DeleteMapping(value={"/{tableIds}"})
    public DataResult<Object> remove(@PathVariable Long[] tableIds) {
        this.genTableService.deleteGenTableByIds(tableIds);
        return GenController.ok();
    }

    @GetMapping(value={"/preview/{tableId}"})
    public DataResult<Object> preview(@PathVariable(value="tableId") Long tableId) {
        Map<String, String> dataMap = this.genTableService.previewCode(tableId);
        return GenController.ok(dataMap);
    }

    @GetMapping(value={"/download/{tableName}"})
    public void download(HttpServletResponse response, @PathVariable(value="tableName") String tableName) throws IOException {
        byte[] data = this.genTableService.downloadCode(tableName);
        this.genCode(response, data, tableName);
    }

    @GetMapping(value={"/genCode/{tableName}"})
    public DataResult<Object> genCode(@PathVariable(value="tableName") String tableName) {
        this.genTableService.generatorCode(tableName);
        return GenController.ok();
    }

    @GetMapping(value={"/synchDb/{tableName}"})
    public DataResult<Object> synchDb(@PathVariable(value="tableName") String tableName) {
        this.genTableService.synchDb(tableName);
        return GenController.ok();
    }

    @GetMapping(value={"/batchGenCode"})
    public void batchGenCode(HttpServletResponse response, String tables) throws IOException {
        String[] tableNames = Convert.toStrArray((String)tables);
        byte[] data = this.genTableService.downloadCode(tableNames);
        this.genCode(response, data, tables);
    }

    private void genCode(HttpServletResponse response, byte[] data, String fileName) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".zip");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IOUtils.write((byte[])data, (OutputStream)response.getOutputStream());
    }
}

