/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.plugins.gen.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import plus.easydo.core.exception.BaseException;
import plus.easydo.core.exception.CustomException;
import plus.easydo.jdbc.utils.DataSourceExecTool;
import plus.easydo.starter.plugins.gen.entity.GenTable;
import plus.easydo.starter.plugins.gen.entity.GenTableColumn;
import plus.easydo.starter.plugins.gen.mapper.GenTableColumnMapper;
import plus.easydo.starter.plugins.gen.mapper.GenTableMapper;
import plus.easydo.starter.plugins.gen.rowmapper.GenTableColumnRowMapper;
import plus.easydo.starter.plugins.gen.rowmapper.GenTableRowMapper;
import plus.easydo.starter.plugins.gen.service.IGenTableService;
import plus.easydo.starter.plugins.gen.service.TemplateManagementService;
import plus.easydo.starter.plugins.gen.util.GenUtils;
import plus.easydo.starter.plugins.gen.util.VelocityInitializer;
import plus.easydo.starter.plugins.gen.util.VelocityUtils;
import plus.easydo.starter.plugins.gen.vo.TemplateManagementVo;
import plus.easydo.utils.StringUtils;

@Service
public class GenTableServiceImpl
extends ServiceImpl<GenTableMapper, GenTable>
implements IGenTableService {
    private static final Logger log = LoggerFactory.getLogger(GenTableServiceImpl.class);
    private static final String vm = ".vm";
    private static final RowMapperResultSetExtractor<GenTable> genTableSetExtractor = new RowMapperResultSetExtractor((RowMapper)new GenTableRowMapper());
    private static final RowMapperResultSetExtractor<GenTableColumn> genTableColumnSetExtractor = new RowMapperResultSetExtractor((RowMapper)new GenTableColumnRowMapper());
    @Autowired
    private GenTableColumnMapper genTableColumnMapper;
    @Autowired
    private TemplateManagementService templateManagementService;
    @Autowired
    private DataSourceExecTool dataSourceExecTool;
    @Autowired
    VelocityInitializer velocityInitializer;

    @Override
    public GenTable selectGenTableById(Long id) {
        GenTable genTable = ((GenTableMapper)this.baseMapper).selectGenTableById(id);
        this.setTableFromOptions(genTable);
        return genTable;
    }

    @Override
    public List<GenTable> selectGenTableList(GenTable genTable) {
        return ((GenTableMapper)this.baseMapper).selectGenTableList(genTable);
    }

    @Override
    public List<GenTable> selectDbTableList(GenTable genTable) {
        StringBuilder stringBuilder = new StringBuilder();
        String sql = "select table_name, table_comment, create_time, update_time from information_schema.tables where table_schema = (select database()) AND table_name NOT LIKE 'qrtz_%' AND table_name NOT LIKE 'gen_%'";
        stringBuilder.append(sql);
        if (StrUtil.isNotBlank((CharSequence)genTable.getTableName())) {
            stringBuilder.append(" AND lower(table_name) like lower(concat('%', ").append("'").append(genTable.getTableName()).append("'").append(", '%')) ");
        }
        if (StrUtil.isNotBlank((CharSequence)genTable.getTableComment())) {
            stringBuilder.append(" AND lower(table_comment) like lower(concat('%', ").append("'").append(genTable.getTableComment()).append("'").append(", '%')) ");
        }
        if (StrUtil.isNotBlank((CharSequence)genTable.getTableName())) {
            stringBuilder.append("AND lower(table_name) like lower(concat('%', ").append("'").append(genTable.getTableName()).append("'").append(", '%'))");
        }
        return (List)this.dataSourceExecTool.query(genTable.getDataSourceId(), stringBuilder.toString(), genTableSetExtractor);
    }

    @Override
    public List<GenTable> selectDbTableListByNames(String dataSourceId, String[] tableNames) {
        StringBuilder startBuilder = new StringBuilder();
        StringBuilder endBuilder = new StringBuilder();
        String sql = "select table_name, table_comment, create_time, update_time from information_schema.tables where table_name NOT LIKE 'qrtz_%' and table_name NOT LIKE 'gen_%' and table_schema = (select database()) ";
        startBuilder.append(sql);
        endBuilder.append(" and table_name in (");
        for (String tableName : tableNames) {
            endBuilder.append("'").append(tableName).append("'").append(",");
        }
        String endSql = endBuilder.substring(0, endBuilder.length() - 1);
        startBuilder.append(endSql).append(")");
        return (List)this.dataSourceExecTool.query(dataSourceId, startBuilder.toString(), genTableSetExtractor);
    }

    @Override
    public List<GenTable> selectGenTableAll() {
        return ((GenTableMapper)this.baseMapper).selectGenTableAll();
    }

    @Override
    @Transactional
    public void updateGenTable(GenTable genTable) {
        String options = JSON.toJSONString((Object)genTable.getParams());
        genTable.setOptions(options);
        int row = ((GenTableMapper)this.baseMapper).updateGenTable(genTable);
        if (row > 0) {
            for (GenTableColumn cenTableColumn : genTable.getColumns()) {
                this.genTableColumnMapper.updateGenTableColumn(cenTableColumn);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteGenTableByIds(Long[] tableIds) {
        ((GenTableMapper)this.baseMapper).deleteGenTableByIds(tableIds);
        this.genTableColumnMapper.deleteGenTableColumnByIds(tableIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importGenTable(String dataSourceId, List<GenTable> tableList) {
        String operationName = "easy-do";
        try {
            for (GenTable table : tableList) {
                String tableName = table.getTableName();
                GenUtils.initTable(table, operationName);
                int row = ((GenTableMapper)this.baseMapper).insertGenTable(table);
                if (row <= 0) continue;
                List<GenTableColumn> genTableColumns = this.selectDbTableColumnsByName(dataSourceId, tableName);
                for (GenTableColumn column : genTableColumns) {
                    GenUtils.initColumnField(column, table);
                    this.genTableColumnMapper.insertGenTableColumn(column);
                }
            }
        }
        catch (Exception e) {
            throw new CustomException("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<GenTableColumn> selectDbTableColumnsByName(String dataSourceId, String tableName) {
        String sql = "select column_name, (case when (is_nullable = 'no' && column_key != 'PRI') then '1' else null end) as is_required, (case when column_key = 'PRI' then '1' else '0' end) as is_pk, ordinal_position as sort, column_comment, (case when extra = 'auto_increment' then '1' else '0' end) as is_increment, column_type  from information_schema.columns where table_schema = (select database()) and table_name = '" + tableName + "' order by ordinal_position";
        return (List)this.dataSourceExecTool.query(dataSourceId, sql, genTableColumnSetExtractor);
    }

    @Override
    public Map<String, String> previewCode(Long tableId) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        GenTable table = ((GenTableMapper)this.baseMapper).selectGenTableById(tableId);
        this.setSubTable(table);
        this.setPkColumn(table);
        VelocityContext context = VelocityUtils.prepareContext(table);
        String templateIds = table.getTemplateIds();
        Map<TemplateManagementVo, Template> templates = this.getTemplatesForDb(templateIds);
        for (Map.Entry<TemplateManagementVo, Template> entry : templates.entrySet()) {
            StringWriter stringWriter = new StringWriter();
            TemplateManagementVo vo = entry.getKey();
            Template template = entry.getValue();
            template.merge((Context)context, (Writer)stringWriter);
            dataMap.put(vo.getFileName(), stringWriter.toString());
        }
        return dataMap;
    }

    @Override
    public byte[] downloadCode(String tableName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        this.generatorCode(tableName, zip);
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    @Override
    public void generatorCode(String tableName) {
        GenTable table = ((GenTableMapper)this.baseMapper).selectGenTableByName(tableName);
        this.setSubTable(table);
        this.setPkColumn(table);
        VelocityContext context = VelocityUtils.prepareContext(table);
        String templateIds = table.getTemplateIds();
        Map<TemplateManagementVo, Template> templates = this.getTemplatesForDb(templateIds);
        for (Map.Entry<TemplateManagementVo, Template> entry : templates.entrySet()) {
            StringWriter stringWriter = new StringWriter();
            TemplateManagementVo vo = entry.getKey();
            Template template = entry.getValue();
            template.merge((Context)context, (Writer)stringWriter);
            try {
                String path = VelocityUtils.generatePath(table, vo.getFilePath());
                FileUtils.writeStringToFile((File)new File(path), (String)stringWriter.toString(), (String)"UTF-8");
            }
            catch (IOException e) {
                throw new CustomException("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + table.getTableName());
            }
        }
    }

    @Override
    @Transactional
    public void synchDb(String tableName) {
        GenTable table = ((GenTableMapper)this.baseMapper).selectGenTableByName(tableName);
        List<GenTableColumn> tableColumns = table.getColumns();
        List tableColumnNames = tableColumns.stream().map(GenTableColumn::getColumnName).collect(Collectors.toList());
        List<GenTableColumn> dbTableColumns = this.genTableColumnMapper.selectDbTableColumnsByName(tableName);
        if (StringUtils.isEmpty(dbTableColumns)) {
            throw new CustomException("\u540c\u6b65\u6570\u636e\u5931\u8d25\uff0c\u539f\u8868\u7ed3\u6784\u4e0d\u5b58\u5728");
        }
        List dbTableColumnNames = dbTableColumns.stream().map(GenTableColumn::getColumnName).collect(Collectors.toList());
        dbTableColumns.forEach(column -> {
            if (!tableColumnNames.contains(column.getColumnName())) {
                GenUtils.initColumnField(column, table);
                this.genTableColumnMapper.insertGenTableColumn((GenTableColumn)((Object)column));
            }
        });
        List<GenTableColumn> delColumns = tableColumns.stream().filter(column -> !dbTableColumnNames.contains(column.getColumnName())).collect(Collectors.toList());
        if (StringUtils.isNotEmpty(delColumns)) {
            this.genTableColumnMapper.deleteGenTableColumns(delColumns);
        }
    }

    @Override
    public byte[] downloadCode(String[] tableNames) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        for (String tableName : tableNames) {
            this.generatorCode(tableName, zip);
        }
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    private void generatorCode(String tableName, ZipOutputStream zip) {
        GenTable table = ((GenTableMapper)this.baseMapper).selectGenTableByName(tableName);
        this.setSubTable(table);
        this.setPkColumn(table);
        VelocityContext context = VelocityUtils.prepareContext(table);
        String templateIds = table.getTemplateIds();
        Map<TemplateManagementVo, Template> templates = this.getTemplatesForDb(templateIds);
        for (Map.Entry<TemplateManagementVo, Template> entry : templates.entrySet()) {
            StringWriter stringWriter = new StringWriter();
            TemplateManagementVo vo = entry.getKey();
            Template template = entry.getValue();
            template.merge((Context)context, (Writer)stringWriter);
            try {
                zip.putNextEntry(new ZipEntry(VelocityUtils.generatePath(table, vo.getFilePath())));
                IOUtils.write((String)stringWriter.toString(), (OutputStream)zip, (String)"UTF-8");
                IOUtils.closeQuietly((Writer)stringWriter);
                zip.flush();
                zip.closeEntry();
            }
            catch (IOException e) {
                log.error("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + table.getTableName(), (Throwable)e);
            }
        }
    }

    @Override
    public void validateEdit(GenTable genTable) {
        if ("tree".equals(genTable.getTplCategory())) {
            String options = JSON.toJSONString((Object)genTable.getParams());
            JSONObject paramsObj = JSONObject.parseObject((String)options);
            if (StringUtils.isEmpty((String)paramsObj.getString("treeCode"))) {
                throw new CustomException("\u6811\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)paramsObj.getString("treeParentCode"))) {
                throw new CustomException("\u6811\u7236\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)paramsObj.getString("treeName"))) {
                throw new CustomException("\u6811\u540d\u79f0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ("sub".equals(genTable.getTplCategory())) {
                if (StringUtils.isEmpty((String)genTable.getSubTableName())) {
                    throw new CustomException("\u5173\u8054\u5b50\u8868\u7684\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)genTable.getSubTableFkName())) {
                    throw new CustomException("\u5b50\u8868\u5173\u8054\u7684\u5916\u952e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }

    public void setPkColumn(GenTable table) {
        for (GenTableColumn column : table.getColumns()) {
            if (!column.isPk()) continue;
            table.setPkColumn(column);
            break;
        }
        if (StringUtils.isNull((Object)((Object)table.getPkColumn()))) {
            table.setPkColumn(table.getColumns().get(0));
        }
        if ("sub".equals(table.getTplCategory())) {
            for (GenTableColumn column : table.getSubTable().getColumns()) {
                if (!column.isPk()) continue;
                table.getSubTable().setPkColumn(column);
                break;
            }
            if (StringUtils.isNull((Object)((Object)table.getSubTable().getPkColumn()))) {
                table.getSubTable().setPkColumn(table.getSubTable().getColumns().get(0));
            }
        }
    }

    public void setSubTable(GenTable table) {
        String subTableName = table.getSubTableName();
        if (StringUtils.isNotEmpty((String)subTableName)) {
            table.setSubTable(((GenTableMapper)this.baseMapper).selectGenTableByName(subTableName));
        }
    }

    public void setTableFromOptions(GenTable genTable) {
        JSONObject paramsObj = JSONObject.parseObject((String)genTable.getOptions());
        if (StringUtils.isNotNull((Object)paramsObj)) {
            String treeCode = paramsObj.getString("treeCode");
            String treeParentCode = paramsObj.getString("treeParentCode");
            String treeName = paramsObj.getString("treeName");
            String parentMenuId = paramsObj.getString("parentMenuId");
            String parentMenuName = paramsObj.getString("parentMenuName");
            genTable.setTreeCode(treeCode);
            genTable.setTreeParentCode(treeParentCode);
            genTable.setTreeName(treeName);
            genTable.setParentMenuId(parentMenuId);
            genTable.setParentMenuName(parentMenuName);
        }
    }

    @Deprecated
    public static String getGenPath(GenTable table, String template) {
        String genPath = table.getGenPath();
        if (StringUtils.equals((CharSequence)genPath, (CharSequence)"/")) {
            return System.getProperty("user.dir") + File.separator + "src" + File.separator + VelocityUtils.getFileName(template, table);
        }
        return genPath + File.separator + VelocityUtils.getFileName(template, table);
    }

    Map<String, Template> getTemplatesForLocalhost(GenTable genTable) {
        HashMap<String, Template> templates = new HashMap<String, Template>();
        VelocityInitializer.initVelocityClasspathResourceLoader();
        List<String> filePaths = VelocityUtils.getTemplatePathList(genTable.getIsManager(), genTable.getTplCategory());
        for (String filePath : filePaths) {
            templates.put(filePath, Velocity.getTemplate((String)filePath, (String)"UTF-8"));
        }
        return templates;
    }

    Map<TemplateManagementVo, Template> getTemplatesForDb(String templateIds) {
        VelocityInitializer.initVelocityStringResourceLoader();
        HashMap<TemplateManagementVo, Template> templates = new HashMap<TemplateManagementVo, Template>();
        if (StrUtil.isEmpty((CharSequence)templateIds)) {
            throw new BaseException("\u672a\u7ed1\u5b9a\u6a21\u677f");
        }
        String[] ids = templateIds.split(",");
        List<TemplateManagementVo> templateManagementVos = this.templateManagementService.selectByIds(ids);
        for (TemplateManagementVo vo : templateManagementVos) {
            String code = vo.getTemplateCode();
            if (!StrUtil.isNotBlank((CharSequence)code)) continue;
            try {
                String fileName = vo.getFileName();
                StringResourceRepository repo = StringResourceLoader.getRepository();
                repo.putStringResource(fileName, vo.getTemplateCode());
                Template template = Velocity.getTemplate((String)fileName);
                templates.put(vo, template);
            }
            catch (Exception e) {
                throw new BaseException("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
            }
        }
        return templates;
    }
}

