/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.plugins.gen.util;

import cn.hutool.core.util.StrUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.RegExUtils;
import plus.easydo.starter.plugins.gen.configure.GenConfig;
import plus.easydo.starter.plugins.gen.constant.GenConstants;
import plus.easydo.starter.plugins.gen.entity.GenTable;
import plus.easydo.starter.plugins.gen.entity.GenTableColumn;

public class GenUtils {
    public static void initTable(GenTable genTable, String operationName) {
        genTable.setClassName(GenUtils.convertClassName(genTable.getTableName()));
        genTable.setPackageName(GenConfig.getPackageName());
        genTable.setModuleName(GenUtils.getModuleName(GenConfig.getPackageName()));
        genTable.setBusinessName(GenUtils.getBusinessName(genTable.getTableName()));
        genTable.setFunctionName(GenUtils.replaceText(genTable.getTableComment()));
        genTable.setFunctionAuthor(GenConfig.getAuthor());
        genTable.setCreateBy(operationName);
    }

    public static void initColumnField(GenTableColumn column, GenTable table) {
        String dataType = GenUtils.getDbType(column.getColumnType());
        String columnName = column.getColumnName();
        column.setTableId(table.getTableId());
        column.setCreateBy(table.getCreateBy());
        column.setJavaField(StrUtil.toCamelCase((CharSequence)columnName));
        column.setJavaType("String");
        if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_STR, dataType) || GenUtils.arraysContains(GenConstants.COLUMNTYPE_TEXT, dataType)) {
            Integer columnLength = GenUtils.getColumnLength(column.getColumnType());
            String htmlType = columnLength >= 500 || GenUtils.arraysContains(GenConstants.COLUMNTYPE_TEXT, dataType) ? "textarea" : "input";
            column.setHtmlType(htmlType);
        } else if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_TIME, dataType)) {
            column.setJavaType("LocalDateTime");
            column.setHtmlType("datetime");
        } else if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_NUMBER, dataType)) {
            column.setHtmlType("input");
            List str = StrUtil.split((CharSequence)StrUtil.subBetween((CharSequence)column.getColumnType(), (CharSequence)"(", (CharSequence)")"), (CharSequence)",");
            if (str != null && str.size() == 2 && Integer.parseInt((String)str.get(1)) > 0) {
                column.setJavaType("BigDecimal");
            } else if (str != null && str.size() == 1 && Integer.parseInt((String)str.get(0)) <= 10) {
                column.setJavaType("Integer");
            } else {
                column.setJavaType("Long");
            }
        }
        column.setIsInsert("1");
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_EDIT, columnName) && !column.isPk()) {
            column.setIsEdit("1");
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_LIST, columnName) && !column.isPk()) {
            column.setIsList("1");
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_QUERY, columnName) && !column.isPk()) {
            column.setIsQuery("1");
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"name")) {
            column.setQueryType("LIKE");
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"status")) {
            column.setHtmlType("radio");
        } else if (StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"type") || StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"sex")) {
            column.setHtmlType("select");
        } else if (StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"image")) {
            column.setHtmlType("imageUpload");
        } else if (StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"file")) {
            column.setHtmlType("fileUpload");
        } else if (StrUtil.endWithIgnoreCase((CharSequence)columnName, (CharSequence)"content")) {
            column.setHtmlType("editor");
        }
    }

    public static boolean arraysContains(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static String getModuleName(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        int nameLength = packageName.length();
        return StrUtil.sub((CharSequence)packageName, (int)(lastIndex + 1), (int)nameLength);
    }

    public static String getBusinessName(String tableName) {
        int lastIndex = tableName.lastIndexOf("_");
        int nameLength = tableName.length();
        return StrUtil.sub((CharSequence)tableName, (int)(lastIndex + 1), (int)nameLength);
    }

    public static String convertClassName(String tableName) {
        boolean autoRemovePre = GenConfig.getAutoRemovePre();
        String tablePrefix = GenConfig.getTablePrefix();
        if (autoRemovePre && StrUtil.isNotBlank((CharSequence)tablePrefix)) {
            String[] searchList = tablePrefix.split(",");
            tableName = GenUtils.replaceFirst(tableName, searchList);
        }
        return StrUtil.toCamelCase((CharSequence)tableName);
    }

    public static String replaceFirst(String replacementm, String[] searchList) {
        String text = replacementm;
        for (String searchString : searchList) {
            if (!replacementm.startsWith(searchString)) continue;
            text = replacementm.replaceFirst(searchString, "");
            break;
        }
        return text;
    }

    public static String replaceText(String text) {
        return RegExUtils.replaceAll((String)text, (String)"(?:\u8868|\u82e5\u4f9d)", (String)"");
    }

    public static String getDbType(String columnType) {
        if (StrUtil.indexOf((CharSequence)columnType, (char)'(') > 0) {
            return StrUtil.subBefore((CharSequence)columnType, (CharSequence)"(", (boolean)false);
        }
        return columnType;
    }

    public static Integer getColumnLength(String columnType) {
        if (StrUtil.indexOf((CharSequence)columnType, (char)'(') > 0) {
            String length = StrUtil.subBetween((CharSequence)columnType, (CharSequence)"(", (CharSequence)")");
            return Integer.valueOf(length);
        }
        return 0;
    }
}

