package plus.easydo.utils;



import org.springframework.beans.BeanUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

/**
 * 返回结果转换工具类
 *
 * @author laoyu
 */
public class ResultConvertUtil {

    private ResultConvertUtil() {
    }

    /**
     * 结果集合转换
     * @param resources 原数据集合
     * @param target 目标
     * @param <A> 元数据对象
     * @param <B> 目标数据
     * @return 转换完成的对象集合
     */
    public static <A,B> List<B> copyList(List<A> resources, Supplier<B> target){
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        return resources.stream().map(re->{
            B b = target.get();
            BeanUtils.copyProperties(re,b);
            return b;
        }).collect(Collectors.toList());
    }

    /**
     * 结果集合转换
     * @param resources 原数据集合
     * @param target 目标
     * @param <A> 元数据对象
     * @param <B> 目标数据
     * @return 转换完成的对象集合
     */
    public static <A,B> B convertVo(A resources, Supplier<B> target){
        B b = target.get();
        if (Objects.isNull(resources)){
            return b;
        }
        BeanUtils.copyProperties(resources, b);
        return b;
    }
}
