package plus.easydo.utils;

import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.NumberUtil;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * @author yuzhanfeng
 */
public class ServletUtil {

    /**
     * 获取ServletRequestAttributes对象
     */
    private static ServletRequestAttributes getServletRequest() {
        return (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
    }

    /**
     * 获取HttpServletRequest对象
     *
     * @return javax.servlet.http.HttpServletRequest
     * @author laoyu
     */
    public static HttpServletRequest getRequest() {
        return getServletRequest().getRequest();
    }

    /**
     * 根据key获取参数
     *
     * @param param        参数key
     * @param defaultValue 默认值
     * @return 参数值
     */
    public static String getParameter(String param, String defaultValue) {
        String parameter = getRequest().getParameter(param);
        return Validator.isNotEmpty(parameter) ? parameter : defaultValue;
    }

    /**
     * 根据key获取参数
     *
     * @param param        参数key
     * @param defaultValue 默认值
     * @return 参数值
     */
    public static Integer getParameter(String param, Integer defaultValue) {
        String parameter = getRequest().getParameter(param);

        return Validator.isNotEmpty(parameter) ? NumberUtil.parseInt(parameter) : defaultValue;
    }
}
