/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.utils;

import cn.hutool.core.net.NetUtil;

public class SnowFlakeUtil {
    private static final long START_TIME_STAMP = 1604370284000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATA_CENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATA_CENTER_LEFT = 17L;
    private static final long TIME_STAMP_LEFT = 22L;
    private static long dataCenterId = 1L;
    private static long machineId = 0L;
    private static final SnowFlakeUtil INSTANCE = new SnowFlakeUtil(dataCenterId, machineId);
    private long sequence = 0L;
    private long lastTimeStamp = -1L;

    public SnowFlakeUtil(long dataCenterId, long machineId) {
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException("\u6570\u636e\u4e2d\u5fc3ID \u9700\u8981\u57280\u548c31\u4e4b\u95f4");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("\u673a\u5668\u6807\u8bc6 \u9700\u8981\u57280\u548c31\u4e4b\u95f4");
        }
        SnowFlakeUtil.dataCenterId = dataCenterId;
        SnowFlakeUtil.machineId = machineId;
    }

    public static SnowFlakeUtil getInstance() {
        return INSTANCE;
    }

    public synchronized long nextId() {
        long currTimeStamp = this.getTime();
        if (currTimeStamp < this.lastTimeStamp) {
            throw new RuntimeException("\u7cfb\u7edf\u65f6\u949f\u6539\u53d8.  \u65e0\u6cd5\u751f\u6210ID");
        }
        if (currTimeStamp == this.lastTimeStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currTimeStamp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimeStamp = currTimeStamp;
        return currTimeStamp - 1604370284000L << 22 | dataCenterId << 17 | machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getTime();
        while (mill <= this.lastTimeStamp) {
            mill = this.getTime();
        }
        return mill;
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    static {
        machineId = NetUtil.ipv4ToLong((String)NetUtil.getLocalhostStr()) % 32L;
    }
}

