/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.utils.node;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import plus.easydo.utils.node.CustomNodeFunction;

public class NodeUtils {
    private NodeUtils() {
    }

    public static <T, R> List<T> getChildrenList(T root, List<T> allList, Function<T, R> pFunction, Function<T, R> cFunction, CustomNodeFunction<T, List<T>> operation) {
        Stream<Object> stream = allList.stream().filter(i -> pFunction.apply(root).equals(cFunction.apply(i)));
        List children = stream.map(m -> {
            List<Object> list = NodeUtils.getChildrenList(m, allList, pFunction, cFunction, operation);
            operation.operationChildNode(m, list);
            return m;
        }).collect(Collectors.toList());
        return children;
    }

    public static <T, R> List<T> generateTree(List<T> allList, Predicate<? super T> predicate, Function<T, R> pFunction, Function<T, R> cFunction, CustomNodeFunction<T, List<T>> operation) {
        List allParentList = allList.stream().filter(predicate).collect(Collectors.toList());
        return allParentList.stream().map(p -> {
            List<Object> list = NodeUtils.getChildrenList(p, allList, pFunction, cFunction, operation);
            operation.operationChildNode(p, list);
            return p;
        }).collect(Collectors.toList());
    }
}

